package ru.yandex.market.logshatter.parser.delivery.component;

import ru.yandex.market.logshatter.parser.delivery.component.jsondata.QueueTaskLogContext;

public class QueueTaskLogEntry extends LogEntry {
    private static final String LOG_DELIMIT_REGEX = "^\\[(\\S+ \\S+)] ([^:]+):([^:]+)[: ]*([\\s|\\S]+) (\\{[\\s|\\S]+\\}) (\\[\\]|\\{[\\s|\\S]+\\})$";

    public QueueTaskLogEntry(String recordText) throws Exception {
        super(recordText);
    }

    @Override
    public String getPatternString() {
        return LOG_DELIMIT_REGEX;
    }

    @Override
    public void setContext(String context) throws Exception {
        this.context = new QueueTaskLogContext(context);
    }

    public QueueTaskLogContext getQueueTaskContext() {
        return (QueueTaskLogContext) getContext();
    }
}
