package ru.yandex.market.logshatter.parser.delivery.component.jsondata;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CronTaskLogContext extends DeliveryApplicationLogJsonData {
    public CronTaskLogContext(String json) throws Exception {
        super(json);
    }

    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private Date getDateByKey(String dateKey) throws Exception {
        return new Date((long) getFloatElementByKey(dateKey) * 1000);
    }

    public String getId() {
        return getStringElementByKey("id");
    }

    public Date getStartTime() throws Exception {
        return getDateByKey("startTime");
    }

    public Date getEndTime() throws Exception {
        return getDateByKey("endTime");
    }

    public Integer getExitCode() {
        return getIntElementByKey("exitCode");
    }

    public String getController() {
        return getStringElementByKey("controller");
    }

    public String getAction() {
        return getStringElementByKey("action");
    }

    public String[] getOptionsKeys() {
        return getKeysArrayElementByKey("options");
    }

    public String getOptions() {
        return getStringFromJsonObjectByKey("options");
    }

    public String[] getArgs() {
        return getValuesArrayElementByKey("args");
    }

    public Integer getDuration() {
        return getIntElementByKey("duration");
    }

    public Integer getMemoryPeakUsage() {
        return getIntElementByKey("memory");
    }

    public String getEnvironment() {
        return getStringElementByKey("environment");
    }

    public String getHostname() {
        return getStringElementByKey("hostname");
    }

    public String getFullHostname() {
        return getStringElementByKey("full_hostname");
    }

    public String[] getContextKeys() {
        return getKeysArrayElementByKey("context");
    }

    public String getContext() {
        return getStringFromJsonObjectByKey("context");
    }

}
