package ru.yandex.market.logshatter.parser.delivery.component.jsondata;

import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.ExternalDataRequest;
import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.ExternalDataResponse;

/**
 * @author Aleksandr Kondrashin aezhko@yandex-team.ru
 *         02.03.16.
 */
public class DeliveryApplicationLogExternalData extends DeliveryApplicationLogJsonData {
    ExternalDataResponse response;
    ExternalDataRequest request;

    public DeliveryApplicationLogExternalData(String json) throws Exception {
        super(json);

        response = new ExternalDataResponse(getStringElementByKey("response"));
        request = new ExternalDataRequest(getStringElementByKey("request"));
    }

    public String getExecutionTime() {
        return getStringElementByKey("executionTime");
    }

    public String getResourceId() {
        return getStringElementByKey("resourceId");
    }

    public String getHostname() {
        return getStringElementByKey("hostname");
    }

    public String getApplicationId() {
        return getStringElementByKey("applicationId");
    }

    public String getUserId() {
        return getStringElementByKey("userId");
    }

    public String getUrl() {
        return getStringElementByKey("url");
    }

    public int gethttpCode() {
        return getIntElementByKey("httpCode");
    }

    public int getMemoryPeakUsage() {
        return getIntElementByKey("memoryPeakUsage");
    }

    public ExternalDataResponse getResponse() throws Exception {
        return response;
    }

    public ExternalDataRequest getRequest() {
        return request;
    }
}