package ru.yandex.market.logshatter.parser.delivery.component.jsondata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

import java.util.ArrayList;

/**
 * @author Aleksandr Kondrashin aezhko@yandex-team.ru
 * 04.03.16.
 */
public abstract class DeliveryApplicationLogJsonData {
    private static final String EMPTY_JSON_VALUE = "[]";

    protected JsonObject jsonObject;

    public DeliveryApplicationLogJsonData(String json) throws Exception {
        if (json.equals(EMPTY_JSON_VALUE)) {
            json = "{}";
        }

        JsonElement jsonElement = new JsonParser().parse(json);
        jsonObject = jsonElement.getAsJsonObject();
    }

    public JsonObject getJsonObject() {
        return jsonObject;
    }

    protected String getStringElementByKey(String key) {
        String result = "";

        try {
            result = jsonObject.getAsJsonPrimitive(key).getAsString();
        } catch (Exception e) {
            // Does nothing.
        }

        return result;
    }

    protected String getStringFromJsonObjectByKey(String key) {
        String result = "";

        try {
            result = jsonObject.get(key).toString();
        } catch (Exception e) {
            // Does nothing.
        }

        return result;
    }

    protected int getIntElementByKey(String key) {
        int result = 0;

        try {
            result = jsonObject.getAsJsonPrimitive(key).getAsInt();
        } catch (Exception e) {
            //Does nothing.
        }

        return result;
    }

    protected float getFloatElementByKey(String key) {
        float result = 0;

        try {
            result = jsonObject.getAsJsonPrimitive(key).getAsFloat();
        } catch (Exception e) {
            // Does nothing.
        }

        return result;
    }

    protected String[] getValuesArrayElementByKey(String key) {
        String[] result = new String[0];

        try {
            JsonArray jsonArray = jsonObject.getAsJsonArray(key);

            ArrayList<String> keys = new ArrayList<>();

            jsonArray.forEach(jsonElement -> {
                keys.add(jsonElement.getAsString());
            });

            result = keys.toArray(new String[keys.size()]);
        } catch (Exception e) {
            // Does nothing.
        }

        return result;
    }

    protected String[] getKeysArrayElementByKey(String key) {
        String[] result = new String[0];

        try {
            JsonObject jsonArray = jsonObject.getAsJsonObject(key);

            ArrayList<String> keys = new ArrayList<>();

            jsonArray.entrySet().forEach(stringJsonElementEntry -> {
                keys.add(stringJsonElementEntry.getKey());
            });

            result = keys.toArray(new String[keys.size()]);
        } catch (Exception e) {
            // Does nothing.
        }

        return result;
    }

    @Override
    public String toString() {
        return jsonObject.toString();
    }
}
