package ru.yandex.market.logshatter.parser.delivery.component.jsondata;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class QueueTaskLogContext extends DeliveryApplicationLogJsonData {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public QueueTaskLogContext(String json) throws Exception {
        super(json);
    }

    private Date getDateByKey(String dateKey) throws Exception {
        return dateFormat.parse(getStringElementByKey(dateKey));
    }

    public String getFunction() {
        return getStringElementByKey("functionName");
    }

    public String getCommand() {
        return getStringElementByKey("command");
    }

    public String getStatus() {
        return getStringElementByKey("status");
    }

    public Date getSetTime() throws Exception {
        return getDateByKey("setTime");
    }

    public Date getStartTime() throws Exception {
        return getDateByKey("startTime");
    }

    public Date getEndTime() throws Exception {
        return getDateByKey("endTime");
    }

    public Integer getMemoryPeakUsage() {
        return getIntElementByKey("memoryPeakUsage");
    }

    public Integer getWorkersCount() {
        return getIntElementByKey("workersCount");
    }

    public Integer getDuration() {
        return getIntElementByKey("duration");
    }
}
