package ru.yandex.market.logshatter.parser.delivery.component.parsablecontent;

import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher.resourceid.SenderIdSearcher;
import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher.resourceid.ShipmentIdSearcher;
import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher.resourceid.WarehouseIdSearcher;
import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher.singlexmlelement.TokenSearcher;

/**
 * @author Aleksandr Kondrashin aezhko@yandex-team.ru
 *         14.03.16.
 */
public class ExternalDataRequest extends ParsableContentWithDefaultSearchers {
    private ShipmentIdSearcher shipmentIdSearcher;
    private TokenSearcher tokenSearcher;
    private WarehouseIdSearcher warehouseIdSearcher;
    private SenderIdSearcher senderIdSearcher;

    public ExternalDataRequest(String originalString) throws Exception {
        super(originalString);
    }

    @Override
    protected void initSearchers() {
        super.initSearchers();

        shipmentIdSearcher = new ShipmentIdSearcher(this);
        tokenSearcher = new TokenSearcher(this);
        warehouseIdSearcher = new WarehouseIdSearcher(this);
        senderIdSearcher = new SenderIdSearcher(this);
    }

    public String[] getShipmentIdYandexArray() {
        return shipmentIdSearcher.getYandexIdList().toArray(new String[0]);
    }

    public String[] getShipmentIdDeliveryArray() {
        return shipmentIdSearcher.getDeliveryIdList().toArray(new String[0]);
    }

    public String[] getWarehouseIdYandexArray() {
        return warehouseIdSearcher.getYandexIdList().toArray(new String[0]);
    }

    public String[] getWarehouseIdDeliveryArray() {
        return warehouseIdSearcher.getDeliveryIdList().toArray(new String[0]);
    }

    public String[] getSenderIdYandexArray() {
        return senderIdSearcher.getYandexIdList().toArray(new String[0]);
    }

    public String getToken() {
        return tokenSearcher.getResult();
    }
}