package ru.yandex.market.logshatter.parser.delivery.component.parsablecontent;

import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher.DeliveryNumSearcher;
import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher.RequestStateSearcher;

/**
 * @author Aleksandr Kondrashin aezhko@yandex-team.ru
 *         04.03.16.
 */
public class ExternalDataResponse extends ParsableContentWithDefaultSearchers {
    protected DeliveryNumSearcher deliveryNumSearcher;
    protected RequestStateSearcher requestStateSearcher;

    public ExternalDataResponse(String originalString) throws Exception {
        super(originalString);
    }

    @Override
    protected void initSearchers() {
        super.initSearchers();

        deliveryNumSearcher = new DeliveryNumSearcher(this);
        requestStateSearcher = new RequestStateSearcher(this);
    }

    public String[] getIntakeIdDeliveryArray() {
        return intakeIDSearcher.getDeliveryIdList().toArray(new String[0]);
    }

    public String[] getDeliveryNumArray() {
        return deliveryNumSearcher.getDeliveryNumList().toArray(new String[0]);
    }

    public String[] getRegisterIdDeliveryArray() {
        return registerIdSearcher.getDeliveryIdList().toArray(new String[0]);
    }

    public int getIsError() {
        return isError() ? 1 : 0;
    }

    public boolean isError() {
        return requestStateSearcher.isError();
    }
}