package ru.yandex.market.logshatter.parser.delivery.component.parsablecontent;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Aleksandr Kondrashin aezhko@yandex-team.ru
 *         02.03.16.
 */
abstract public class ParsableContent {
    private static final String SEARCH_XML_REGEXP = "(<\\?xml [\\s|\\S]+<\\/\\S+>)";
    private static final String SEARCH_JSON_REGEXP = "(\\{[\\s\\S]+\\})";

    protected String originalString;
    protected JsonObject jsonObject = null;
    protected Document xmlObject = null;

    public ParsableContent(String originalString) throws Exception {
        this.originalString = originalString;

        detectJson();
        detectXml();
    }

    private void detectXml() throws Exception {
        if (originalString.contains("<?xml")) {
            String xmlString = getXmlSubstring(originalString);

            if (!xmlString.isEmpty()) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                InputSource is = new InputSource(new StringReader(xmlString));

                xmlObject = builder.parse(is);
            }
        }
    }

    private String getXmlSubstring(String string) {
        Pattern pattern = Pattern.compile(SEARCH_XML_REGEXP);
        Matcher matcher = pattern.matcher(string);

        if (matcher.find()) {
            return matcher.group(1);
        }

        return "";
    }

    private void detectJson() {
        if (originalString.contains("{")) {
            String jsonString = getJsonSubstring(originalString);

            if (!jsonString.isEmpty()) {
                try {
                    JsonElement jsonElement = new JsonParser().parse(jsonString);
                    jsonObject = jsonElement.getAsJsonObject();
                } catch (Exception e) {
                    //Does nothing
                }
            }
        }
    }

    private String getJsonSubstring(String string) {
        Pattern pattern = Pattern.compile(SEARCH_JSON_REGEXP);
        Matcher matcher = pattern.matcher(string);

        if (matcher.find()) {
            return matcher.group(1);
        }

        return "";
    }

    public JsonObject getJsonObject() {
        return jsonObject;
    }

    public Document getXmlObject() {
        return xmlObject;
    }

    @Override
    public String toString() {
        return originalString;
    }
}