package ru.yandex.market.logshatter.parser.delivery.component.parsablecontent;

import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher.MethodNameSearcher;
import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher.resourceid.IntakeIDSearcher;
import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher.resourceid.OrderIdSearcher;
import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher.resourceid.RegisterIdSearcher;
import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher.resourceid.SelfExportIdSearcher;
import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher.singlexmlelement.HashSearcher;

/**
 * @author Aleksandr Kondrashin aezhko@yandex-team.ru
 *         15.03.16.
 */
public class ParsableContentWithDefaultSearchers extends ParsableContent {
    protected OrderIdSearcher orderIdSearcher;
    protected IntakeIDSearcher intakeIDSearcher;
    protected SelfExportIdSearcher selfExportIdSearcher;
    protected RegisterIdSearcher registerIdSearcher;
    protected HashSearcher hashSearcher;
    protected MethodNameSearcher methodNameSearcher;

    public ParsableContentWithDefaultSearchers(String originalString) throws Exception {
        super(originalString);

        initSearchers();
    }

    protected void initSearchers() {
        orderIdSearcher = new OrderIdSearcher(this);
        intakeIDSearcher = new IntakeIDSearcher(this);
        selfExportIdSearcher = new SelfExportIdSearcher(this);
        registerIdSearcher = new RegisterIdSearcher(this);
        hashSearcher = new HashSearcher(this);
        methodNameSearcher = new MethodNameSearcher(this);
    }

    public String[] getOrderIdCleanArray() {
        return orderIdSearcher.getCleanOrderIdList().toArray(new String[0]);
    }

    public String[] getOrderIdYandexArray() {
        return orderIdSearcher.getYandexIdList().toArray(new String[0]);
    }

    public String[] getOrderIdDeliveryArray() {
        return orderIdSearcher.getDeliveryIdList().toArray(new String[0]);
    }

    public String[] getOrderIdExternalArray() {
        return orderIdSearcher.getExternalIdList().toArray(new String[0]);
    }

    public String[] getIntakeIdYandexArray() {
        return intakeIDSearcher.getYandexIdList().toArray(new String[0]);
    }

    public String[] getSelfExportIdYandexArray() {
        return selfExportIdSearcher.getYandexIdList().toArray(new String[0]);
    }

    public String[] getSelfExportIdDeliveryArray() {
        return selfExportIdSearcher.getDeliveryIdList().toArray(new String[0]);
    }

    public String[] getRegisterIdYandexArray() {
        return registerIdSearcher.getYandexIdList().toArray(new String[0]);
    }

    public String getHash() {
        return hashSearcher.getResult();
    }

    public String getMethodName() {
        return methodNameSearcher.getMethodName();
    }
}