package ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.datatype;

import org.w3c.dom.Element;

/**
 * @author Aleksandr Kondrashin aezhko@yandex-team.ru
 *         14.03.16.
 */
public class ResourceId {
    private String yandexId;
    private String deliveryId;
    private String externalId;

    public ResourceId(Element resourceIdElement) {
        if (resourceIdElement.getElementsByTagName("yandexId").getLength() > 0) {
            yandexId = resourceIdElement.getElementsByTagName("yandexId").item(0).getTextContent();
        }

        if (resourceIdElement.getElementsByTagName("deliveryId").getLength() > 0) {
            deliveryId = resourceIdElement.getElementsByTagName("deliveryId").item(0).getTextContent();
        }

        if (resourceIdElement.getElementsByTagName("externalId").getLength() > 0) {
            externalId = resourceIdElement.getElementsByTagName("externalId").item(0).getTextContent();
        }
    }

    public String getYandexId() {
        return yandexId;
    }

    public String getDeliveryId() {
        return deliveryId;
    }

    public String getExternalId() {
        return externalId;
    }
}