package ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.ParsableContent;

import java.util.ArrayList;

/**
 * @author Aleksandr Kondrashin aezhko@yandex-team.ru
 *         15.03.16.
 */
public class DeliveryNumSearcher extends Searcher {
    protected ArrayList<String> deliveryNumList;

    public DeliveryNumSearcher(ParsableContent content) {
        super(content);
    }

    @Override
    protected void beforeSearch() {
        deliveryNumList = new ArrayList<>();
    }

    @Override
    protected void search() {
        NodeList deliveryNumTagNodes = getOriginalXml().getElementsByTagName("deliveryNum");

        if (deliveryNumTagNodes.getLength() > 0) {
            parseDeliveryNumTags(deliveryNumTagNodes);
        }
    }

    private void parseDeliveryNumTags(NodeList deliveryNumTagNodes) {
        for (int tagNum = 0; tagNum < deliveryNumTagNodes.getLength(); tagNum++) {
            if (deliveryNumTagNodes.item(tagNum) instanceof Element) {
                parseDeliveryNumElement((Element) deliveryNumTagNodes.item(tagNum));
            }
        }
    }

    private void parseDeliveryNumElement(Element deliveryNumElement) {
        String deliveryNum = deliveryNumElement.getTextContent();

        if (!deliveryNum.isEmpty()) {
            deliveryNumList.add(deliveryNum);
        }
    }

    public ArrayList<String> getDeliveryNumList() {
        return deliveryNumList;
    }
}