package ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.ParsableContent;

/**
 * @author Aleksandr Kondrashin aezhko@yandex-team.ru
 *         15.03.16.
 */
public class MethodNameSearcher extends Searcher {
    private String methodName;

    public MethodNameSearcher(ParsableContent content) {
        super(content);
    }

    @Override
    protected void beforeSearch() {
        methodName = "";
    }

    @Override
    protected void search() {
        NodeList nodes = getOriginalXml().getElementsByTagName("request");

        if (nodes.getLength() == 0) {
            nodes = getOriginalXml().getElementsByTagName("response");
        }

        if (nodes.getLength() == 1) {
            getMethodNameFromElement((Element) nodes.item(0));
        }
    }

    protected void getMethodNameFromElement(Element element) {
        String typeAttributeValue = element.getAttribute("type");

        if (!typeAttributeValue.isEmpty()) {
            methodName = typeAttributeValue;
        }
    }

    public String getMethodName() {
        return methodName;
    }
}