package ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.ParsableContent;

/**
 * @author Aleksandr Kondrashin aezhko@yandex-team.ru
 *         15.03.16.
 */
public class RequestStateSearcher extends Searcher {
    private boolean isError;

    public RequestStateSearcher(ParsableContent content) {
        super(content);
    }


    @Override
    protected void beforeSearch() {
        super.beforeSearch();
    }

    @Override
    protected void search() {
        isError = true;

        NodeList requestStateNodes = getOriginalXml().getElementsByTagName("requestState");

        parseRequestStateNodes(requestStateNodes);
    }

    private void parseRequestStateNodes(NodeList requestStateNodes) {
        if (requestStateNodes.getLength() == 1 && requestStateNodes.item(0) instanceof Element) {
            NodeList isErrorNodes = ((Element) requestStateNodes.item(0)).getElementsByTagName("isError");

            if (isErrorNodes.getLength() == 1) {
                parseIsErrorNodes(isErrorNodes);
            }
        }
    }

    private void parseIsErrorNodes(NodeList isErrorNodes) {
        String nodeValue = isErrorNodes.item(0).getTextContent();

        if (nodeValue.trim().equals("false")) {
            isError = false;
        }
    }

    public boolean isError() {
        return isError;
    }
}