package ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher;

import org.w3c.dom.Document;
import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.ParsableContent;

/**
 * @author Aleksandr Kondrashin aezhko@yandex-team.ru
 *         14.03.16.
 */
abstract public class Searcher {
    protected Document originalXml;

    public Searcher(ParsableContent content) {
        beforeSearch();

        if (content.getXmlObject() != null) {
            originalXml = content.getXmlObject();
            search();
        }
    }

    public Document getOriginalXml() {
        return originalXml;
    }

    protected void beforeSearch() {

    }

    abstract protected void search();
}