package ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher.resourceid;

import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.ParsableContent;
import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.datatype.ResourceId;

import java.util.ArrayList;

/**
 * @author Aleksandr Kondrashin aezhko@yandex-team.ru
 *         14.03.16.
 */
public class OrderIdSearcher extends ResourceIdSearcher {
    protected ArrayList<String> cleanOrderIdList;

    public OrderIdSearcher(ParsableContent content) {
        super(content);
    }

    @Override
    protected void beforeInitArrayLists() {
        cleanOrderIdList = new ArrayList<>();
    }

    @Override
    protected void afterParseResourceId(ResourceId resourceIdObject) {
        if (resourceIdObject.getYandexId() != null) {
            parseFullYandexOrderId(resourceIdObject.getYandexId());
        }
    }

    private void parseFullYandexOrderId(String yandexOrderId) {
        String[] parsedId = yandexOrderId.split("-YD");

        if (parsedId.length > 1) {
            cleanOrderIdList.add(parsedId[1]);
        }
    }

    public ArrayList<String> getCleanOrderIdList() {
        return cleanOrderIdList;
    }

    @Override
    protected String getTagName() {
        return "orderId";
    }
}