package ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher.resourceid;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.ParsableContent;
import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.datatype.ResourceId;
import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher.Searcher;

import java.util.ArrayList;

/**
 * @author Aleksandr Kondrashin aezhko@yandex-team.ru
 *         15.03.16.
 */
abstract public class ResourceIdSearcher extends Searcher {
    protected ArrayList<String> yandexIdList;
    protected ArrayList<String> deliveryIdList;
    protected ArrayList<String> externalIdList;

    public ResourceIdSearcher(ParsableContent content) {
        super(content);
    }

    @Override
    protected void beforeSearch() {
        initArrayLists();
    }

    @Override
    protected void search() {
        NodeList orderIdNodes = getOriginalXml().getElementsByTagName(getTagName());

        if (orderIdNodes.getLength() > 0) {
            parseOrderIdNodes(orderIdNodes);
        }

        if (getOldStyleTagName() != null && !getOldStyleTagName().isEmpty()) {
            parseOldStyleTags(getOldStyleTagName());
        }
    }

    private void parseOrderIdNodes(NodeList orderIdNodes) {
        for (int nodeItemNum = 0; nodeItemNum < orderIdNodes.getLength(); nodeItemNum++) {
            Node orderIdNode = orderIdNodes.item(nodeItemNum);

            if (orderIdNode instanceof Element) {
                ResourceId orderIdObject = new ResourceId((Element) orderIdNode);
                storeResourceIdData(orderIdObject);
            }
        }
    }

    protected void initArrayLists() {
        beforeInitArrayLists();

        yandexIdList = new ArrayList<>();
        deliveryIdList = new ArrayList<>();
        externalIdList = new ArrayList<>();
    }

    protected void storeResourceIdData(ResourceId resourceIdObject) {
        if (resourceIdObject.getYandexId() != null) {
            yandexIdList.add(resourceIdObject.getYandexId());
        }

        if (resourceIdObject.getDeliveryId() != null) {
            deliveryIdList.add(resourceIdObject.getDeliveryId());
        }

        if (resourceIdObject.getExternalId() != null) {
            externalIdList.add(resourceIdObject.getExternalId());
        }

        afterParseResourceId(resourceIdObject);
    }

    private void parseOldStyleTags(String oldStyleTagName) {
        NodeList oldStyleTagNodes = getOriginalXml().getElementsByTagName(oldStyleTagName);

        for (int tagNum = 0; tagNum < oldStyleTagNodes.getLength(); tagNum++) {
            if (oldStyleTagNodes.item(tagNum) instanceof Element) {
                NodeList idTags = ((Element) oldStyleTagNodes.item(tagNum)).getElementsByTagName("id");

                if (idTags.getLength() == 1 && idTags.item(0) instanceof Element) {
                    parseOldStyleIdTagElement((Element) idTags.item(0));
                }
            }
        }
    }

    private void parseOldStyleIdTagElement(Element idTagElement) {
        NodeList yandexIdNodes = idTagElement.getElementsByTagName("yandexId");
        NodeList deliveryIdNodes = idTagElement.getElementsByTagName("deliveryId");

        if (yandexIdNodes.getLength() == 1 && yandexIdNodes.item(0) instanceof Element) {
            String value = yandexIdNodes.item(0).getTextContent();

            if (!value.isEmpty()) {
                yandexIdList.add(value);
            }
        }

        if (deliveryIdNodes.getLength() == 1 && yandexIdNodes.item(0) instanceof Element) {
            String value = deliveryIdNodes.item(0).getTextContent();

            if (!value.isEmpty()) {
                deliveryIdList.add(value);
            }
        }
    }

    abstract protected String getTagName();

    protected String getOldStyleTagName() {
        return null;
    }

    protected void beforeInitArrayLists() {

    }

    protected void afterParseResourceId(ResourceId resourceIdObject) {

    }

    public ArrayList<String> getYandexIdList() {
        return yandexIdList;
    }

    public ArrayList<String> getDeliveryIdList() {
        return deliveryIdList;
    }

    public ArrayList<String> getExternalIdList() {
        return externalIdList;
    }
}