package ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher.resourceid;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.ParsableContent;

/**
 * @author Aleksandr Kondrashin aezhko@yandex-team.ru
 *         15.03.16.
 */
public class SelfExportIdSearcher extends ResourceIdSearcher {
    public SelfExportIdSearcher(ParsableContent content) {
        super(content);
    }

    @Override
    protected void search() {
        super.search();

        NodeList intakeNumTags = getOriginalXml().getElementsByTagName("selfExportNum");

        if (intakeNumTags.getLength() > 0) {
            parseIntakeNumTags(intakeNumTags);
        }
    }

    private void parseIntakeNumTags(NodeList intakeNumTags) {
        for (int tagNum = 0; tagNum < intakeNumTags.getLength(); tagNum++) {
            if (intakeNumTags.item(tagNum) instanceof Element) {
                parseIntakeNumElement((Element) intakeNumTags.item(tagNum));
            }
        }
    }

    private void parseIntakeNumElement(Element intakeNumElement) {
        String intakeNum = intakeNumElement.getTextContent();

        if (!intakeNum.isEmpty()) {
            deliveryIdList.add(intakeNum);
        }
    }

    @Override
    protected String getTagName() {
        return "selfExportId";
    }
}
