package ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher.singlexmlelement;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.ParsableContent;
import ru.yandex.market.logshatter.parser.delivery.component.parsablecontent.searcher.Searcher;

/**
 * @author Aleksandr Kondrashin aezhko@yandex-team.ru
 *         15.03.16.
 */
abstract public class SingleXmlElementSearcher extends Searcher {
    protected String result;

    public SingleXmlElementSearcher(ParsableContent content) {
        super(content);
    }

    @Override
    protected void beforeSearch() {
        result = "";
    }

    @Override
    protected void search() {
        NodeList tokenNodes = getOriginalXml().getElementsByTagName(getTagName());

        if (tokenNodes.getLength() == 1 && tokenNodes.item(0) instanceof Element) {
            getValueFromElement((Element) tokenNodes.item(0));
        }
    }

    private void getValueFromElement(Element tokenElement) {
        String value = tokenElement.getTextContent();

        if (!value.isEmpty()) {
            result = value;
        }
    }

    abstract protected String getTagName();

    public String getResult() {
        return result;
    }
}