package ru.yandex.market.logshatter.parser.direct;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickhouse.ddl.enums.EnumArrayColumnType;
import ru.yandex.market.clickhouse.ddl.enums.EnumColumnType;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.clickhouse.ddl.engine.MergeTree;
import ru.yandex.market.clickhouse.ddl.engine.EngineType;

import java.lang.Long;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonElement;

public class BinlogRowsLogParser implements LogParser {
    enum Operation {
        INSERT(1),
        UPDATE(2),
        DELETE(3),
        SCHEMA(4);
        private final int code;

        private Operation(int code) {
            this.code = code;
        }

        public int getCode() {
            return code;
        }
    }

    enum RowIsNull {
        FALSE(0),
        TRUE(1);
        private final int value;

        private RowIsNull(int value) {
            this.value = value;
        }

        public int getValue() {
            return value;
        }
    }

    private static final TableDescription TABLE_DESCRIPTION = createTableDescription();
    private static TableDescription createTableDescription() {
        String dateColumnName = "date";
        String timestampColumnName = "datetime";
        List<Column> columns = new ArrayList<Column>(Arrays.asList(
            new Column(dateColumnName, ColumnType.Date),
            new Column(timestampColumnName, ColumnType.DateTime),
            new Column("reqid", ColumnType.Int64),
            new Column("method", ColumnType.String),
            new Column("service", ColumnType.String),
            new Column("source", ColumnType.String),
            new Column("db", ColumnType.String),
            new Column("table", ColumnType.String),
            new Column("operation", EnumColumnType.enum8(Operation.class)),
            new Column("gtid", ColumnType.String),
            new Column("gtid_src", ColumnType.String),
            new Column("gtid_scn", ColumnType.Int64),
            new Column("query_seq_num", ColumnType.UInt32),
            new Column("change_seq_num", ColumnType.UInt32),
            new Column("primary_key", ColumnType.String, null, null, "ZSTD(5)"),
            new Column("primary_key_schema", ColumnType.String),
            new Column("row.name", ColumnType.ArrayString, null, null, "ZSTD(5)"),
            new Column("row.value", ColumnType.ArrayString, null, null, "ZSTD(5)"),
            new Column("row.is_null", EnumArrayColumnType.enum8Array(RowIsNull.class))
       ));
       List<String> primaryKeys = new ArrayList<String>(Arrays.asList(
            dateColumnName,
            "db",
            "table",
            "primary_key",
            "gtid",
            "change_seq_num",
            "cityHash64(primary_key)"
       ));

       MergeTree engineType = new MergeTree("toYYYYMM(" + dateColumnName + ")", primaryKeys, null, 8192);
       return new TableDescription(columns, engineType);
    }
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }
    private static final Gson gson = new Gson();
    @Override
    public void parse(String line, ParserContext context) throws Exception {
        JsonObject rec = gson.fromJson(line, JsonObject.class);
        long timestamp = rec.get("utcTimestamp").getAsLong() * 1000;
        Date date = new Date(timestamp);

        long reqid = rec.get("traceInfoReqId").getAsLong();
        String service = rec.get("traceInfoService").getAsString();
        String method = rec.get("traceInfoMethod").getAsString();
        String source = rec.get("source").getAsString();
        String gtidSrc = rec.get("serverUuid").getAsString();
        long gtidScn = rec.get("transactionId").getAsLong();
        int querySeqNum = rec.get("queryIndex").getAsInt();
        //String gtid = gtidSrc + ':' + Long.toString(gtidScn); #DIRECT-117544
        String gtid = "";
        String db = rec.get("db").getAsString();
        String table = rec.get("table").getAsString();
        Operation operation = Operation.valueOf(rec.get("operation").getAsString());
        int changeSeqNum = 0;
        if (operation.getCode() == 4 && rec.get("rows").getAsJsonArray().size() == 0) {
            //DIRECTADMIN-8648. В SCHEMA rows может быть пустым
            String primaryKey = "";
            String primaryKeySchema = "";
            List<String> rowNames = new ArrayList<String>();
            List<String> rowValues = new ArrayList<String>();
            List<RowIsNull> rowIsNull = new ArrayList<RowIsNull>();
            context.write(date, reqid, method, service, source, db, table, operation, gtid, gtidSrc, gtidScn,
                    querySeqNum, changeSeqNum, primaryKey, primaryKeySchema, rowNames, rowValues, rowIsNull);
        } else {
            for (JsonElement elem : rec.get("rows").getAsJsonArray()) {
                //int changeSeqNum = elem.getAsJsonObject().get("rowIndex").getAsInt(); #DIRECT-117544
                Set<Map.Entry<String, JsonElement>> beforeRowsEntrySet = elem.getAsJsonObject().getAsJsonObject("before").entrySet();
                Set<Map.Entry<String, JsonElement>> afterRowsEntrySet = elem.getAsJsonObject().getAsJsonObject("after").entrySet();
                Map<String, JsonElement> beforeRowKV = new HashMap<String, JsonElement>();
                Map<String, JsonElement> afterRowKV = new HashMap<String, JsonElement>();
                for (Map.Entry<String, JsonElement> kv : beforeRowsEntrySet) {
                    beforeRowKV.put(kv.getKey(), kv.getValue());
                }
                for (Map.Entry<String, JsonElement> kv : afterRowsEntrySet) {
                    afterRowKV.put(kv.getKey(), kv.getValue());
                }
                List<String> allRowNames = new ArrayList<>(afterRowKV.keySet());
                List<String> rowNames = new ArrayList<String>();
                List<String> rowValues = new ArrayList<String>();
                List<RowIsNull> rowIsNull = new ArrayList<RowIsNull>();
                Collections.sort(allRowNames, String.CASE_INSENSITIVE_ORDER);
                if (operation == Operation.INSERT || operation == Operation.UPDATE) {
                    for (String k : allRowNames) {
                        JsonElement valueObject = afterRowKV.get(k);
                        if (operation == Operation.UPDATE && beforeRowKV.containsKey(k) && beforeRowKV.get(k).equals(valueObject)) {
                            continue;
                        }
                        String v;
                        if (valueObject.isJsonPrimitive() && !valueObject.isJsonNull()) {
                            v = valueObject.getAsString();
                        } else {
                            v = valueObject.toString();
                        }
                        rowNames.add(k);
                        rowValues.add(v);
                        rowIsNull.add(valueObject.isJsonNull() ? RowIsNull.TRUE : RowIsNull.FALSE);
                    }
                }

                Set<Map.Entry<String, JsonElement>> pkEntrySet = elem.getAsJsonObject().getAsJsonObject("primaryKey").entrySet();
                Map<String, JsonElement> pkKV = new HashMap<String, JsonElement>();
                for (Map.Entry<String, JsonElement> kv : pkEntrySet) {
                    pkKV.put(kv.getKey(), kv.getValue());
                }
                List<String> pkColNames = new ArrayList<>(pkKV.keySet());
                Collections.sort(pkColNames, String.CASE_INSENSITIVE_ORDER);
                StringBuilder pkBuilder = new StringBuilder("");
                StringBuilder pkSchemaBuilder = new StringBuilder("");
                for (String k : pkColNames) {
                    JsonElement valueObject = pkKV.get(k);
                    String v;
                    if (valueObject.isJsonPrimitive() && !valueObject.isJsonNull()) {
                        v = valueObject.getAsString();
                    } else {
                        v = valueObject.toString();
                    }
                    if (pkBuilder.length() != 0) {
                        pkBuilder.append(",");
                        pkSchemaBuilder.append(",");
                    }
                    pkSchemaBuilder.append(k);
                    pkBuilder.append(v);
                }
                String primaryKey = pkBuilder.toString();
                String primaryKeySchema = pkSchemaBuilder.toString();
                int collapsingSign = 1;
                context.write(date, reqid, method, service, source, db, table, operation, gtid, gtidSrc, gtidScn,
                    querySeqNum, changeSeqNum, primaryKey, primaryKeySchema, rowNames, rowValues, rowIsNull);
            }
        }
    }

}
