package ru.yandex.market.logshatter.parser.direct;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

import com.google.gson.*;
import com.google.gson.stream.JsonReader;

import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.direct.bsexport.BaseBsExportLogParser;
import ru.yandex.market.logshatter.parser.direct.bsexport.BsExportDataLine;
import ru.yandex.market.logshatter.parser.direct.logformat.BsExportFormat;


public class BsExportDataRequestLogParser extends BaseBsExportLogParser {

    // за основу взята ./protected/BS/Export/Queues.pm
    private static final Map<String, Integer> parIdsType = new HashMap<String, Integer>() {{
        put("std", 0);          //"стандартная очередь"
        put("camp", 10);        //"очередь заказов и новых кошельков"
        put("stdprice", 19);    //"очередь цен"
        put("heavy", 29);       //"тяжёлая очередь"
        put("fast", 40);        //"быстрая очередь"
        put("dev1", 50);        //"разработческая очередь 1"
        put("dev2", 55);        //"разработческая очередь 2"
        put("preprod", 74);     //"очередь preprod"
        put("devprice", 80);    //"разработческая очередь цен 1"
        put("devprice2", 85);   //"разработческая очередь цен 2"
        put("buggy", 90);       //"buggy очередь"
        put("std", 209);        //"очередь для полной переотправки в LB",
        put("notfound", -1);     //"не найдена информация об очереди"
    }};

    private Long getParIdsType(String value) {
        String[] queue = value.split("_");
        int groupId = parIdsType.containsKey(queue[0]) ? parIdsType.get(queue[0]) : -1;
        int personId = (queue.length > 1) ? Integer.parseInt(queue[(queue.length - 1)]) : 0;
        return new Long(groupId + personId);
    }

    private static String DATATYPE = "request";

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        JsonReader reader;

        try {
            reader = new JsonReader(new StringReader(line));
            Gson gson = new GsonBuilder().create();

            reader.beginArray();

            while (reader.hasNext()) {
                BsExportFormat bsexport = gson.fromJson(reader, BsExportFormat.class);
                bsexport.setDataType(DATATYPE);
                if (bsexport.getLevel().equals("PRICE")) {
                    continue;
                }
                if (bsexport.getFullExportFlag()) {
                    continue;
                }
                if (bsexport.getLevel().equals("ORDER")) {
                    write(new BsExportDataLine()
                                    .setLogTime(bsexport.getTime())
                                    .setCid(bsexport.getCid())
                                    .setParId(getParIdsType(bsexport.getParType()))
                                    .setParType(bsexport.getParType())
                                    .setDataType(bsexport.getDataType())
                                    .setPid(bsexport.getPid())
                                    .setBid(bsexport.getBid())
                                    .setSource("file:" + context.getHost())
                                    .setMetadata(bsexport.toString())
                                    .setData(bsexport.getData()),
                            context);
                }
                if (bsexport.getLevel().equals("CONTEXT")) {
                    JsonObject banners = bsexport.getBanners();
                    for (String key : banners.keySet()) {
                        JsonElement bid = banners.get(key).getAsJsonObject().get("EID");
                        write(new BsExportDataLine()
                                        .setLogTime(bsexport.getTime())
                                        .setCid(bsexport.getCid())
                                        .setParId(getParIdsType(bsexport.getParType()))
                                        .setParType(bsexport.getParType())
                                        .setDataType(bsexport.getDataType())
                                        .setPid(bsexport.getPid())
                                        .setBid(bid.getAsLong())
                                        .setSource("file:" + context.getHost())
                                        .setMetadata(bsexport.toString())
                                        .setData(banners.get(key)),
                                context);
                    }

                    bsexport.removeBanners();
                    write(new BsExportDataLine()
                                    .setLogTime(bsexport.getTime())
                                    .setCid(bsexport.getCid())
                                    .setParId(getParIdsType(bsexport.getParType()))
                                    .setParType(bsexport.getParType())
                                    .setDataType(bsexport.getDataType())
                                    .setPid(bsexport.getPid())
                                    .setBid(bsexport.getBid())
                                    .setSource("file:" + context.getHost())
                                    .setMetadata(bsexport.toString())
                                    .setData(bsexport.getData()),
                            context);
                }
            }
            reader.endArray();
            reader.close();
        } catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }
}
