package ru.yandex.market.logshatter.parser.direct;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class DirectParserUtils {
    private DirectParserUtils() {
    }

    public static <T> T nvl(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static int parseNanos(String nanos) {
        if (nanos != null) {
            if (nanos.length() >= 9) {
                return Integer.parseInt(nanos.substring(0, 9));
            } else {
                return Integer.parseInt(nanos) * (int) Math.pow(10, 9 - nanos.length());
            }
        } else {
            return 0;
        }
    }

    public static String getAsStringOrDefault(JsonObject jsonObject, String memberName) {
        JsonElement jsonElement = jsonObject.get(memberName);
        return jsonElement != null && !jsonElement.isJsonNull() ? jsonElement.getAsString() : "";
    }

    public static Long getAsLongOrDefault(JsonObject jsonObject, String memberName) {
        JsonElement jsonElement = jsonObject.get(memberName);
        return jsonElement != null && !jsonElement.isJsonNull() ? jsonElement.getAsLong() : 0L;
    }

    public static Float getAsFloatOrDefault(JsonObject jsonObject, String memberName) {
        JsonElement jsonElement = jsonObject.get(memberName);
        return jsonElement != null && !jsonElement.isJsonNull() ? jsonElement.getAsFloat() : 0.0F;
    }

    public static Double getAsDoubleOrDefault(JsonObject jsonObject, String memberName) {
        JsonElement jsonElement = jsonObject.get(memberName);
        return jsonElement != null && !jsonElement.isJsonNull() ? jsonElement.getAsDouble() : 0.0D;
    }

    public static Boolean getAsBooleanOrDefault(JsonObject jsonObject, String memberName) {
        JsonElement jsonElement = jsonObject.get(memberName);
        return jsonElement != null && !jsonElement.isJsonNull() ? jsonElement.getAsBoolean() : false;
    }
}
