package ru.yandex.market.logshatter.parser.direct;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickhouse.ddl.engine.EngineType;
import ru.yandex.market.clickhouse.ddl.engine.MergeTree;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Date;

public class MediaplanLogParser implements LogParser {

    public static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ssX";
    public final SimpleDateFormat dateFormatPerl = new SimpleDateFormat(DATE_PATTERN);

    public static final Column DATE_COLUMN = new Column("log_date", ColumnType.Date);
    public static final Column TIMESTAMP_COLUMN = new Column("log_time", ColumnType.DateTime);

    private static final String semplName = "intHash64(reqid)";

    public static List<String> additionalPrimaryKeys = Arrays.asList(semplName);
    private static final List<String> primaryKeys = getPrimary();
    private static final String partName = DATE_COLUMN.getName();

    private static final MergeTree DEFAULT_ENGINE = new MergeTree("toYYYYMM(" + partName + ")", primaryKeys, semplName, 8192);

    private static List<Column> columnsStruct = new ArrayList<Column>(Arrays.asList(
        new Column("source", ColumnType.String),
        new Column("reqid", ColumnType.Int64),
        new Column("host", ColumnType.String),
        new Column("cid", ColumnType.Int64),
        new Column("action", ColumnType.String),
        new Column("values", ColumnType.String)
    ));

    public static TableDescription create(EngineType engineType, List<Column> columns) {
        List<Column> allColumns = new ArrayList<>(columns.size() + 2);
        allColumns.add(DATE_COLUMN);
        allColumns.add(TIMESTAMP_COLUMN);
        allColumns.addAll(columns);
        return new TableDescription(allColumns, engineType);
    }

    private static final TableDescription TABLE_DESCRIPTION = create(DEFAULT_ENGINE, columnsStruct);

    private String extractJsonElement(JsonObject json, String key) {
        return (json != null && json.get(key) != null) ? json.get(key).getAsString() : "";
    }

    private static final Gson gson = new Gson();

    private static List<String> getPrimary() {
        List<String> aggrKeys = new ArrayList<>();
        aggrKeys.add(DATE_COLUMN.getName());
        aggrKeys.add(TIMESTAMP_COLUMN.getName());
        aggrKeys.addAll(additionalPrimaryKeys);
        return aggrKeys;
    }


    @Override
    public void parse(String line, ParserContext context) throws Exception {
        String[] matcher = line.split(" ", 10);
        JsonObject element = gson.fromJson(matcher[matcher.length - 1], JsonObject.class);
        Date date = dateFormatPerl.parse(matcher[1]);
        String source = matcher[3];
        String host = matcher[2];

        JsonObject values = element.get("values").getAsJsonObject();
        long reqid = element.get("reqid").getAsLong();
        long cid = element.get("cid").getAsLong();
        String action = element.get("action").getAsString();

        context.write(date, source, reqid, host, cid, action, values.toString());
    }

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }
}