package ru.yandex.market.logshatter.parser.direct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickhouse.ddl.engine.ReplacingMergeTree;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;

public class MySqlSlowLogParserNew implements LogParser {
    private static final TableDescription TABLE_DESCRIPTION = createTableDescription();
    private static final ThreadLocal<Gson> fastGson = ThreadLocal.withInitial(() -> new GsonBuilder().create());
    private static final String sampleName = "intHash64(query_time)";
    private static final String EMPTY = "";

    private static TableDescription createTableDescription() {
        String dateColumnName = "query_date";
        String timestampColumnName = "query_time";
        List<Column> columns = new ArrayList<Column>(Arrays.asList(
            new Column(dateColumnName, ColumnType.Date),
            new Column(timestampColumnName, ColumnType.DateTime),
            new Column("cluster_id", ColumnType.String),
            new Column("cluster_name", ColumnType.String),
            new Column("cluster_version", ColumnType.UInt32),
            new Column("query_id_in_timestamp", ColumnType.UInt32),
            new Column("query_normal_form", ColumnType.String, null, null, "ZSTD(5)"),
            new Column("query_service", ColumnType.String),
            new Column("query_method", ColumnType.String),
            new Column("query_request_id", ColumnType.UInt64),
            new Column("query_text", ColumnType.String, null, null, "ZSTD(5)"),
            new Column("user_name", ColumnType.String),
            new Column("user_second_name", ColumnType.String),
            new Column("user_host", ColumnType.String),
            new Column("user_ip", ColumnType.String),
            new Column("connection_id", ColumnType.UInt64),
            new Column("schema_name", ColumnType.String),
            new Column("last_error_number", ColumnType.Int32),
            new Column("killed_code", ColumnType.Int32),
            new Column("query_time_in_seconds", ColumnType.Float64),
            new Column("lock_time_in_seconds", ColumnType.Float64),
            new Column("rows_sent", ColumnType.Int64),
            new Column("rows_examined", ColumnType.Int64),
            new Column("rows_affected", ColumnType.Int64),
            new Column("bytes_sent", ColumnType.Int64),
            new Column("temp_tables_count", ColumnType.Int32),
            new Column("temp_tables_on_disk_count", ColumnType.Int32),
            new Column("temp_tables_sizes_in_bytes", ColumnType.Int64),
            new Column("transaction_id", ColumnType.UInt64),
            new Column("has_qc_hit", ColumnType.UInt8),
            new Column("has_full_scan", ColumnType.UInt8),
            new Column("has_full_join", ColumnType.UInt8),
            new Column("has_temp_tables", ColumnType.UInt8),
            new Column("has_temp_tables_on_disk", ColumnType.UInt8),
            new Column("has_file_sort", ColumnType.UInt8),
            new Column("has_file_sort_on_disk", ColumnType.UInt8),
            new Column("merge_passes_count", ColumnType.Int32),
            new Column("inno_db_io_reads_count", ColumnType.Int32),
            new Column("inno_db_io_read_bytes_count", ColumnType.Int64),
            new Column("inno_db_read_wait_in_seconds", ColumnType.Float64),
            new Column("inno_db_records_lock_wait_in_seconds", ColumnType.Float64),
            new Column("inno_db_queue_wait_in_seconds", ColumnType.Float64),
            new Column("inno_db_pages_count_distinct", ColumnType.Int32),
            new Column("raw_record_text", ColumnType.String, null, null, "ZSTD(5)")
        ));
        List<String> orderBy = new ArrayList<String>(Arrays.asList(
            timestampColumnName,
            "query_id_in_timestamp",
            "cluster_id",
            sampleName
        ));

        ReplacingMergeTree engineType = new ReplacingMergeTree(
            "toYYYYMM(" + dateColumnName + ")", orderBy, sampleName, 8192);
        return new TableDescription(columns, engineType);
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        MySqlSlowQueryLogRecord record = fastGson.get().fromJson(line, MySqlSlowQueryLogRecord.class);
        Date date = new Date(record.recordIdTimestamp);
        context.write(
            date,
            record.clusterId,
            record.clusterName,
            record.clusterVersion,
            record.recordIdPositionInTimestamp,
            record.queryNormalForm,
            record.queryService,
            record.queryMethod,
            record.queryRequestId,
            record.queryText,
            record.userName,
            record.userSecondName,
            record.userHost,
            record.userIp,
            record.connectionId,
            record.schema,
            record.lastErrorNumber,
            record.killedCode,
            record.queryTimeInSeconds,
            record.lockTimeInSeconds,
            record.rowsSentCount,
            record.rowsExaminedCount,
            record.rowsAffectedCount,
            record.bytesSentCount,
            record.tempTablesCount,
            record.tempTablesOnDiskCount,
            record.tempTablesSizesInBytes,
            record.transactionId,
            record.hasQcHit,
            record.hasFullScan,
            record.hasFullJoin,
            record.hasTempTables,
            record.hasTempTablesOnDisk,
            record.hasFileSort,
            record.hasFileSortOnDisk,
            record.mergePassesCount,
            record.innoDbIoReadOperationsCount,
            record.innoDbIoReadBytesCount,
            record.innoDbReadWaitInSeconds,
            record.innoDbRecordsLockWaitInSeconds,
            record.innoQbQueueWaitInSeconds,
            record.innoDbPagesCountDistinct,
            record.rawRecordText == null ? EMPTY : record.rawRecordText
        );
    }

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    private static class MySqlSlowQueryLogRecord {
        private final String clusterId;
        private final String clusterName;
        private final int clusterVersion;
        private final long recordIdTimestamp;
        private final int recordIdPositionInTimestamp;
        private final String queryNormalForm;
        private final String queryService;
        private final String queryMethod;
        private final long queryRequestId;
        private final String queryText;
        private final String userName;
        private final String userSecondName;
        private final String userHost;
        private final String userIp;
        private final long connectionId;
        private final String schema;
        private final int lastErrorNumber;
        private final int killedCode;
        private final double queryTimeInSeconds;
        private final double lockTimeInSeconds;
        private final long rowsSentCount;
        private final long rowsExaminedCount;
        private final long rowsAffectedCount;
        private final long bytesSentCount;
        private final int tempTablesCount;
        private final int tempTablesOnDiskCount;
        private final long tempTablesSizesInBytes;
        private final long transactionId;
        private final boolean hasQcHit;
        private final boolean hasFullScan;
        private final boolean hasFullJoin;
        private final boolean hasTempTables;
        private final boolean hasTempTablesOnDisk;
        private final boolean hasFileSort;
        private final boolean hasFileSortOnDisk;
        private final int mergePassesCount;
        private final int innoDbIoReadOperationsCount;
        private final long innoDbIoReadBytesCount;
        private final double innoDbReadWaitInSeconds;
        private final double innoDbRecordsLockWaitInSeconds;
        private final double innoQbQueueWaitInSeconds;
        private final int innoDbPagesCountDistinct;
        private final String rawRecordText;

        public MySqlSlowQueryLogRecord(
            String clusterId,
            String clusterName,
            int clusterVersion,
            long recordIdTimestamp,
            int recordIdPositionInTimestamp,
            String queryNormalForm,
            String queryService,
            String queryMethod,
            long queryRequestId,
            String queryText,
            String userName,
            String userSecondName,
            String userHost,
            String userIp,
            long connectionId,
            String schema,
            int lastErrorNumber,
            int killedCode,
            double queryTimeInSeconds,
            double lockTimeInSeconds,
            long rowsSentCount,
            long rowsExaminedCount,
            long rowsAffectedCount,
            long bytesSentCount,
            int tempTablesCount,
            int tempTablesOnDiskCount,
            long tempTablesSizesInBytes,
            long transactionId,
            boolean hasQcHit,
            boolean hasFullScan,
            boolean hasFullJoin,
            boolean hasTempTables,
            boolean hasTempTablesOnDisk,
            boolean hasFileSort,
            boolean hasFileSortOnDisk,
            int mergePassesCount,
            int innoDbIoReadOperationsCount,
            long innoDbIoReadBytesCount,
            double innoDbReadWaitInSeconds,
            double innoDbRecordsLockWaitInSeconds,
            double innoQbQueueWaitInSeconds,
            int innoDbPagesCountDistinct,
            String rawRecordText) {

            this.clusterId = clusterId;
            this.clusterName = clusterName;
            this.clusterVersion = clusterVersion;
            this.recordIdTimestamp = recordIdTimestamp;
            this.recordIdPositionInTimestamp = recordIdPositionInTimestamp;
            this.queryNormalForm = queryNormalForm;
            this.queryService = queryService;
            this.queryMethod = queryMethod;
            this.queryRequestId = queryRequestId;
            this.queryText = queryText;
            this.userName = userName;
            this.userSecondName = userSecondName;
            this.userHost = userHost;
            this.userIp = userIp;
            this.connectionId = connectionId;
            this.schema = schema;
            this.lastErrorNumber = lastErrorNumber;
            this.killedCode = killedCode;
            this.queryTimeInSeconds = queryTimeInSeconds;
            this.lockTimeInSeconds = lockTimeInSeconds;
            this.rowsSentCount = rowsSentCount;
            this.rowsExaminedCount = rowsExaminedCount;
            this.rowsAffectedCount = rowsAffectedCount;
            this.bytesSentCount = bytesSentCount;
            this.tempTablesCount = tempTablesCount;
            this.tempTablesOnDiskCount = tempTablesOnDiskCount;
            this.tempTablesSizesInBytes = tempTablesSizesInBytes;
            this.transactionId = transactionId;
            this.hasQcHit = hasQcHit;
            this.hasFullScan = hasFullScan;
            this.hasFullJoin = hasFullJoin;
            this.hasTempTables = hasTempTables;
            this.hasTempTablesOnDisk = hasTempTablesOnDisk;
            this.hasFileSort = hasFileSort;
            this.hasFileSortOnDisk = hasFileSortOnDisk;
            this.mergePassesCount = mergePassesCount;
            this.innoDbIoReadOperationsCount = innoDbIoReadOperationsCount;
            this.innoDbIoReadBytesCount = innoDbIoReadBytesCount;
            this.innoDbReadWaitInSeconds = innoDbReadWaitInSeconds;
            this.innoDbRecordsLockWaitInSeconds = innoDbRecordsLockWaitInSeconds;
            this.innoQbQueueWaitInSeconds = innoQbQueueWaitInSeconds;
            this.innoDbPagesCountDistinct = innoDbPagesCountDistinct;
            this.rawRecordText = rawRecordText;
        }

        public String getClusterId() {
            return clusterId;
        }

        public String getClusterName() {
            return clusterName;
        }

        public int getClusterVersion() {
            return clusterVersion;
        }

        public long getRecordIdTimestamp() {
            return recordIdTimestamp;
        }

        public int getRecordIdPositionInTimestamp() {
            return recordIdPositionInTimestamp;
        }

        public String getQueryNormalForm() {
            return queryNormalForm;
        }

        public String getQueryService() {
            return queryService;
        }

        public String getQueryMethod() {
            return queryMethod;
        }

        public long getQueryRequestId() {
            return queryRequestId;
        }

        public String getQueryText() {
            return queryText;
        }

        public String getUserName() {
            return userName;
        }

        public String getUserSecondName() {
            return userSecondName;
        }

        public String getUserHost() {
            return userHost;
        }

        public String getUserIp() {
            return userIp;
        }

        public long getConnectionId() {
            return connectionId;
        }

        public String getSchema() {
            return schema;
        }

        public int getLastErrorNumber() {
            return lastErrorNumber;
        }

        public int getKilledCode() {
            return killedCode;
        }

        public double getQueryTimeInSeconds() {
            return queryTimeInSeconds;
        }

        public double getLockTimeInSeconds() {
            return lockTimeInSeconds;
        }

        public long getRowsSentCount() {
            return rowsSentCount;
        }

        public long getRowsExaminedCount() {
            return rowsExaminedCount;
        }

        public long getRowsAffectedCount() {
            return rowsAffectedCount;
        }

        public long getBytesSentCount() {
            return bytesSentCount;
        }

        public int getTempTablesCount() {
            return tempTablesCount;
        }

        public int getTempTablesOnDiskCount() {
            return tempTablesOnDiskCount;
        }

        public long getTempTablesSizesInBytes() {
            return tempTablesSizesInBytes;
        }

        public long getTransactionId() {
            return transactionId;
        }

        public boolean isHasQcHit() {
            return hasQcHit;
        }

        public boolean isHasFullScan() {
            return hasFullScan;
        }

        public boolean isHasFullJoin() {
            return hasFullJoin;
        }

        public boolean isHasTempTables() {
            return hasTempTables;
        }

        public boolean isHasTempTablesOnDisk() {
            return hasTempTablesOnDisk;
        }

        public boolean isHasFileSort() {
            return hasFileSort;
        }

        public boolean isHasFileSortOnDisk() {
            return hasFileSortOnDisk;
        }

        public int getMergePassesCount() {
            return mergePassesCount;
        }

        public int getInnoDbIoReadOperationsCount() {
            return innoDbIoReadOperationsCount;
        }

        public long getInnoDbIoReadBytesCount() {
            return innoDbIoReadBytesCount;
        }

        public double getInnoDbReadWaitInSeconds() {
            return innoDbReadWaitInSeconds;
        }

        public double getInnoDbRecordsLockWaitInSeconds() {
            return innoDbRecordsLockWaitInSeconds;
        }

        public double getInnoQbQueueWaitInSeconds() {
            return innoQbQueueWaitInSeconds;
        }

        public int getInnoDbPagesCountDistinct() {
            return innoDbPagesCountDistinct;
        }

        public String getRawRecordText() {
            return rawRecordText;
        }
    }
}
