package ru.yandex.market.logshatter.parser.direct.logformat;

import com.google.gson.*;
import com.google.gson.annotations.SerializedName;

public abstract class BaseBsExportFormat {
    @SerializedName("log_time")
    private String time;

    @SerializedName("bid")
    private Long bid;

    @SerializedName("pid")
    private Long pid;

    @SerializedName("cid")
    private Long cid;

    @SerializedName("data")
    private JsonElement data;

    private String dataType;

    public void setDataType(String value) {
        this.dataType = value;
    }

    public long getPid() {
        return (pid == null ? 0L : pid);
    }

    public String getTime() {
        return time;
    }

    public long getCid() {
        return (cid == null ? 0L : cid);
    }

    public long getBid() {
        return (bid == null ? 0L : bid);
    }

    public JsonElement getData() {
        return data;
    }

    public String getDataType() {
        return dataType;
    }
}
