package ru.yandex.market.logshatter.parser.direct.logformat;

import com.google.gson.*;
import com.google.gson.annotations.SerializedName;


public class BsExportFormat extends BaseBsExportFormat {
    @SerializedName("host")
    private String host;

    @SerializedName("full_export_flag")
    private int fullExportFlag;

    @SerializedName("level")
    private String level;

    @SerializedName("uuid")
    private String uuid;

    @SerializedName("par_norm_nick")
    private String parType;

    @SerializedName("debug_info")
    private JsonObject debug_info;

    @Override
    public String toString() {
        String meta = "uuid=" + uuid;
        return meta;
    }

    public boolean getFullExportFlag() {
        if (fullExportFlag == 1) { return true; };
        return false;
    }

    public String getLevel() { return level; }

    public String getTime() {
        String time = super.getTime();
        return ( time == null ) ? debug_info.get("send_time").getAsString() : time;
    }

    public JsonObject getBanners() {
        return getData().getAsJsonObject().getAsJsonObject("BANNER");
    }

    public void removeBanners() {
        getData().getAsJsonObject().remove("BANNER");
        return;
    }

    public String getParType() {
        return ( parType == null) ? debug_info.get("par_norm_nick").getAsString() : parType;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null)
            return false;
        if (!(obj instanceof BsExportFormat))
            return false;
        if (obj == this)
            return true;
        return (this.getTime().equals(((BsExportFormat) obj).getTime()) &&
            this.toString().equals(obj.toString()));
    }

    @Override
    public int hashCode() {
        String hashValue = this.toString() + this.getTime();
        return hashValue.hashCode();
    }
}
