package ru.yandex.market.logshatter.parser.direct.logformat;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;

public class BsPricesFormat {

    @SerializedName("full_export_flag")
    private int fullExportFlag;

    @SerializedName("level")
    private String level;

    @SerializedName("host")
    private String host;

    @SerializedName("uuid")
    private String uuid;

    @SerializedName("log_time")
    private String time;

    @SerializedName("par_norm_nick")
    private String parType;

     @SerializedName("bid")
     private Long bid;

     @SerializedName("pid")
     private Long pid;

     @SerializedName("cid")
     private Long cid;

     @SerializedName("data")
     private JsonObject data;

     @SerializedName("debug_info")
     private JsonObject debug_info;

     private String dataType;

     @Override
     public String toString() {
         String meta = "uuid=" + uuid;
         return meta;
     }

     public void setDataType(String value) {
            this.dataType = value;
     }

     public long getPid() { return (pid == null ? 0L : pid); }

     public String getLevel() { return level; }

     public String getTime() {
            return ( time == null ) ? debug_info.get("send_time").getAsString() : time;
        }

     public long getCid() {
            return (cid == null ? 0L : cid);
        }

     public long getBid() {
            return (bid == null ? 0L : bid);
        }

     public String getData() {
            return data.toString();
        }

     public String getParType() {
        return ( parType == null) ? debug_info.get("par_norm_nick").getAsString() : parType;
     }

     public boolean getFullExportFlag() {
        if (fullExportFlag == 1) { return true; };
        return false;
     }

     public String getDataType() {
            return dataType;
        }


     @Override
     public boolean equals(Object obj) {
         if (obj == null)
             return false;
         if (!(obj instanceof BsPricesFormat))
             return false;
         if (obj == this)
             return true;
         return (this.getTime().equals(((BsPricesFormat) obj).getTime()) &&
             this.toString().equals(obj.toString())) &&
             this.cid.equals(((BsPricesFormat) obj).getCid()) &&
             this.pid.equals(((BsPricesFormat) obj).getPid());
     }

     @Override
     public int hashCode() {
         String hashValue = this.toString() + this.getTime() + this.getCid();
         return hashValue.hashCode();
     }
}
