package ru.yandex.market.logshatter.parser.direct.logformat;

import com.google.gson.JsonArray;
import com.google.gson.annotations.SerializedName;

public class BsimportActiveOrdersFormat {

    @SerializedName("OrderID")
    private long OrderID;

    @SerializedName("CostCur")
    private double CostCur;

    @SerializedName("UpdateTime")
    private String UpdateTime;

    @SerializedName("Clicks")
    private long Clicks;

    @SerializedName("OfferShows")
    private long OfferShows;

    @SerializedName("Shows")
    private long Shows;

    @SerializedName("Cost")
    private double Cost;

    @SerializedName("Stop")
    private int Stop;

    @SerializedName("SpentUnits")
    private long SpentUnits;

    public long getOrderID() {
        return this.OrderID;
    }

    public long getCostCur() {
        double value = this.CostCur * 1_000_000;
        return (long) value;
    }

    public String getUpdateTime() {
        return this.UpdateTime;
    }

    public long getClicks() {
        return this.Clicks;
    }

    public long getOfferShows() {
        return this.OfferShows;
    }

    public long getShows() {
        return this.Shows;
    }

    public long getCost() {
        double value = this.Cost * 1_000_000;
        return (long) value;
    }

    public int getStop() {
        return this.Stop;
    }

    public long getSpentUnits() {
        return this.SpentUnits;
    }
}
