package ru.yandex.market.logshatter.parser.direct.logformat;

import com.google.common.base.Strings;

public class DirectAccessFormat {
    String value;
    int MAXSTR = 300;

    public DirectAccessFormat(String value) {
        value = (value.startsWith("\"") && value.endsWith("\"")) ? value.substring(1, value.length() - 1) : value;
        value = value.startsWith("\t") ? "-" + value : value;
        value = value.trim();
        value = value.equals("-") ? "" : value;
        this.value = value;
    }

    public float parseFloat() {
        return Strings.isNullOrEmpty(this.value) ? 0 : Float.valueOf(this.value);
    }

    public int parseInt() {
        return Strings.isNullOrEmpty(this.value) ? 0 : Integer.valueOf(this.value);
    }

    public String parseString() {
        return (value.length() > MAXSTR) ? value.substring(0, MAXSTR) : value;
    }

    public DirectAccessFormatList parseList(String sep) {
        String[] lines = this.value.split(sep);
        DirectAccessFormatList result = new DirectAccessFormatList();
        for (int i = 0; i < lines.length; i++) {
            result.add(new DirectAccessFormat(lines[i]));
        }
        return result;
    }
}
