package ru.yandex.market.logshatter.parser.front;

import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.TskvSplitter;
import ru.yandex.market.logshatter.parser.front.formatters.AppMetrikaEventFormatter;
import ru.yandex.market.logshatter.parser.front.helpers.AppErrorMetrikaContainer;
import ru.yandex.market.logshatter.parser.front.helpers.FrontParserUtils;
import ru.yandex.market.logshatter.parser.front.helpers.tableDestription.MarketErrors;

import java.util.Map;
import java.util.Set;


public class AppMetrikaEventLogParser implements LogParser {
    private static final String ALLOWED_APP_EVENT_VALUE_TYPE = "LOG";
    private static final AppMetrikaEventFormatter METRIKA_FORMATTER = new AppMetrikaEventFormatter();

    private static Set<String> allowedAppEvents;
    private static Map<String, String> apiKeysToServiceNames;

    @Override
    public TableDescription getTableDescription() {
        return MarketErrors.DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        TskvSplitter splitter = new TskvSplitter(line);

        init(context);

        AppErrorMetrikaContainer container = METRIKA_FORMATTER.format(splitter, allowedAppEvents, apiKeysToServiceNames,
            ALLOWED_APP_EVENT_VALUE_TYPE);

        if (container == null) {
            return;
        }

        container.writeToContext(context);
    }

    private void init(ParserContext context) {
        if (apiKeysToServiceNames != null) {
            return;
        }

        allowedAppEvents = FrontParserUtils.parseSetFromString(context.getParam("allowedAppEvents"));
        apiKeysToServiceNames = FrontParserUtils.getServiceNames(context.getParam("apiKeysToServiceNames"));
    }
}
