package ru.yandex.market.logshatter.parser.front;

import ru.yandex.market.logshatter.parser.EnvironmentMapper;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.TskvSplitter;
import ru.yandex.market.logshatter.parser.front.helpers.AppErrorMetrikaContainer;
import ru.yandex.market.logshatter.parser.front.helpers.tableDestription.MarketErrors;

import java.nio.file.Path;
import java.util.Date;

public class ErrorsTskvLogParser implements LogParser {
    private static final String FILE_SUFFIX = "-errors.log";

    private EnvironmentMapper environmentMapper = new EnvironmentMapper(EnvironmentMapper.LOGBROKER_PROTOCOL_PREFIX);

    @Override
    public TableDescription getTableDescription() {
        return MarketErrors.DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        TskvSplitter splitter = new TskvSplitter(line);
        AppErrorMetrikaContainer container = new AppErrorMetrikaContainer();

        String service = getServiceName(context.getFile());

        if (service.isEmpty()) {
            service = splitter.getString(MarketErrors.COLUMN_SERVICE);
        }

        String stackTrace = splitter.getOptionalString(MarketErrors.COLUMN_STACK_TRACE, "");
        String stackTraceHash = "";
        if (!stackTrace.isEmpty()) {
            stackTraceHash = splitter.getString(MarketErrors.COLUMN_STACK_TRACE_HASH);
        }

        String[] tags = {};
        if (splitter.getValues().containsKey(MarketErrors.COLUMN_TAGS)) {
            tags = splitter.getStringArray(MarketErrors.COLUMN_TAGS, ",");
        }

        String[] extraKeys = {};
        String[] extraValues = {};

        if (splitter.getValues().containsKey(MarketErrors.COLUMN_EXTRA_KEYS)) {
            extraKeys = splitter.getStringArray(MarketErrors.COLUMN_EXTRA_KEYS);
            extraValues = splitter.getStringArray(MarketErrors.COLUMN_EXTRA_VALUES);
        }

        container.setService(service);
        container.setDate(new Date(splitter.getLong("timestamp")));
        container.setRequestId(splitter.getOptionalString(MarketErrors.COLUMN_REQUEST_ID, ""));
        container.setStackTrace(stackTrace);
        container.setStackTraceHash(stackTraceHash);
        container.setTags(tags);
        container.setExtraKeys(extraKeys);
        container.setExtraValues(extraValues);
        container.setEnvironment(environmentMapper.getEnvironment(context));
        container.setCode(splitter.getString(MarketErrors.COLUMN_CODE));
        container.setLevel(splitter.getString(MarketErrors.COLUMN_LEVEL));
        container.setMessage(splitter.getString(MarketErrors.COLUMN_MESSAGE));
        container.setFile(splitter.getOptionalString(MarketErrors.COLUMN_FILE, ""));
        container.setLineNumber(splitter.getOptionalInt(MarketErrors.COLUMN_LINE_NO, 0));
        container.setRevision(splitter.getOptionalString(MarketErrors.COLUMN_REVISION, ""));
        container.setPlatform("server");

        container.writeToContext(context);
    }

    private String getServiceName(Path file) {
        String fileName = file.getFileName().toString();
        if (!fileName.endsWith(FILE_SUFFIX)) {
            return "";
        }

        return fileName.substring(0, fileName.length() - FILE_SUFFIX.length());
    }
}
