package ru.yandex.market.logshatter.parser.front;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickhouse.ddl.enums.EnumColumnType;
import ru.yandex.market.logshatter.parser.*;
import ru.yandex.market.logshatter.parser.trace.Environment;

import java.util.Arrays;
import java.util.Date;

public class EventsTskvLogParser implements LogParser {
    private static final String COLUMN_SERVICE = "service";
    private static final String COLUMN_ENVIRONMENT = "environment";
    private static final String COLUMN_EVENT = "event";
    private static final String COLUMN_REQ_ID = "request_id";
    private static final String COLUMN_URL= "url";
    private static final String COLUMN_METHOD= "method";
    private static final String COLUMN_YANDEXUID= "yandexuid";
    private static final String COLUMN_PUID= "puid";
    private static final String COLUMN_MUID= "muid";
    private static final String COLUMN_EXTRA_KEYS= "extra_keys";
    private static final String COLUMN_EXTRA_VALUES= "extra_values";


    public static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        Arrays.asList(COLUMN_SERVICE, COLUMN_ENVIRONMENT),
        new Column(COLUMN_SERVICE, ColumnType.String),
        new Column(COLUMN_EVENT, ColumnType.String),
        new Column(COLUMN_REQ_ID, ColumnType.String),
        new Column(COLUMN_URL, ColumnType.String),
        new Column(COLUMN_METHOD, ColumnType.String),
        new Column(COLUMN_EXTRA_KEYS, ColumnType.ArrayString),
        new Column(COLUMN_EXTRA_VALUES, ColumnType.ArrayString),
        new Column(COLUMN_YANDEXUID, ColumnType.String),
        new Column(COLUMN_PUID, ColumnType.String),
        new Column(COLUMN_MUID, ColumnType.String),
        new Column(
            COLUMN_ENVIRONMENT, EnumColumnType.enum8(Environment.class),
            String.format("'%s'", Environment.UNKNOWN.toString())
        )
    );

    private EnvironmentMapper environmentMapper = new EnvironmentMapper(EnvironmentMapper.LOGBROKER_PROTOCOL_PREFIX);

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        TskvSplitter splitter = new TskvSplitter(line);

        String[] extraKeys = {};
        String[] extraValues = {};

        if (splitter.getValues().containsKey(COLUMN_EXTRA_KEYS)) {
            extraKeys = splitter.getStringArray(COLUMN_EXTRA_KEYS);
            extraValues = splitter.getStringArray(COLUMN_EXTRA_VALUES);
        }

        context.write(
            new Date(splitter.getLong("timestamp")),
            splitter.getString(COLUMN_SERVICE),
            splitter.getString(COLUMN_EVENT),
            splitter.getString(COLUMN_REQ_ID),
            splitter.getString(COLUMN_URL),
            splitter.getString(COLUMN_METHOD),
            extraKeys,
            extraValues,
            splitter.getString(COLUMN_YANDEXUID),
            splitter.getOptionalString(COLUMN_PUID, ""),
            splitter.getOptionalString(COLUMN_MUID, ""),
            environmentMapper.getEnvironment(context)
        );
    }
}
