package ru.yandex.market.logshatter.parser.front;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParserContext;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author Dmitry Andreev <a href="mailto:AndreevDm@yandex-team.ru"></a>
 * @date 31/03/15
 */
public class NodeJsMetricsLogParser implements LogParser {

    private final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss Z");

    public static final TableDescription TABLE_DESCRIPTION = TableDescription.createDefault(
        new Column("host", ColumnType.String),
        new Column("vsize", ColumnType.UInt32),
        new Column("rss", ColumnType.Int32),
        new Column("exp_id", ColumnType.String)
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    /*
    2015/03/31 18:22:03 +0300	pid:9053	vsize:1275760640	rss:133713920
     */
    @Override
    public void parse(String line, ParserContext context) throws Exception {
        String[] splits = line.split("\t");
        Date date = dateFormat.parse(splits[0]);
        Long vsize = Long.valueOf(getSplitValue(splits[2]));
        Integer rss = Integer.valueOf(getSplitValue(splits[3]));
        String expId = NodeJsErrorsLogParser.extractExperimentId(context.getFile());
        context.write(date, context.getHost(), vsize, rss, expId);
    }

    private String getSplitValue(String string) {
        return string.split(":")[1];
    }
}
