package ru.yandex.market.logshatter.parser.front.errorBooster;

public enum Platform {
    DESKTOP,
    TOUCH,
    APP,
    TV,
    PAD,
    TVAPP,
    UNKNOWN,
    STATION;

    public static Platform fromString(String platform) {
        switch (platform) {
            case "desktop":
                return Platform.DESKTOP;
            case "touch":
            case "touch-phone":
            case "phone":
                return Platform.TOUCH;
            case "app":
                return Platform.APP;
            case "tv":
                return Platform.TV;
            case "pad":
                return Platform.PAD;
            case "tvapp":
                return Platform.TVAPP;
            case "station":
                return Platform.STATION;
            default:
                return Platform.UNKNOWN;
        }
    }
}
