package ru.yandex.market.logshatter.parser.front.errorBooster.mordaNode;

import ru.yandex.market.logshatter.parser.TskvSplitter;
import ru.yandex.market.logshatter.parser.front.errorBooster.Environment;
import ru.yandex.market.logshatter.parser.front.errorBooster.schema.CommonSchema;

import static ru.yandex.market.logshatter.parser.ParseUtils.sipHash64;

public class CommonContainer extends CommonSchema {
    public boolean fill(TskvSplitter splitter) throws Exception {
        project = "morda";
        requestId = splitter.getOptionalString("reqid", "");
        requestIdHash = sipHash64(requestId);
        urlId = sipHash64(url);
        environment = prepareEnvironment(splitter.getString("ctype"));

        addKvItem("project", splitter.getString("project"));
        addKvItem("ctype", splitter.getString("ctype"));

        return true;
    }

    public Environment prepareEnvironment(String ctype) {
        switch (ctype) {
            case "assessor":
            case "testing":
            case "load":
                return Environment.TESTING;
            case "dev":
                return Environment.DEVELOPMENT;
            case "stable-old":
            case "stable":
            case "prestable":
                return Environment.PRODUCTION;
            case "unstable":
            case "unstable-old":
                return Environment.PRE_PRODUCTION;
            default:
                return Environment.UNKNOWN;
        }
    }
}
