package ru.yandex.market.logshatter.parser.front.errorBooster.mordaNode;

import ru.yandex.common.util.StringUtils;
import ru.yandex.market.logshatter.parser.TskvSplitter;
import ru.yandex.market.logshatter.parser.front.errorBooster.LogLevel;
import ru.yandex.market.logshatter.parser.front.errorBooster.Parser;
import ru.yandex.market.logshatter.parser.front.errorBooster.Runtime;
import ru.yandex.market.logshatter.parser.front.errorBooster.schema.ErrorsSchema;

import static ru.yandex.market.logshatter.parser.ParseUtils.sipHash64;

public class ErrorsContainer extends ErrorsSchema {
    public boolean fill(TskvSplitter splitter) throws Exception {
        logLevel = LogLevel.fromString(splitter.getString("level"));

        originalMessage = splitter.getString("message");

        if (StringUtils.isEmpty(originalMessage)) {
            return false;
        }
        message = originalMessage;
        messageId = sipHash64(message);

        stackTrace = splitter.getOptionalString("stack", "");
        stackTraceId = sipHash64(stackTrace);

        fileId = sipHash64(file);
        userAgentId = sipHash64(userAgent);

        runtime = Runtime.NODEJS;
        parser = Parser.MORDA_NODE;

        return true;
    }
}

