package ru.yandex.market.logshatter.parser.front.errorBooster.mordaNode;

import org.apache.commons.lang3.ArrayUtils;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParseUtils;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.TskvSplitter;
import ru.yandex.market.logshatter.parser.front.errorBooster.schema.Schema;

import java.util.Date;

public class ErrorsParser implements LogParser {

    public ErrorsParser() {}

    @Override
    public TableDescription getTableDescription() {
        return Schema.TABLE_DESCRIPTION;
    }

    final private static String[] ALLOWED_LEVELS = {"error", "warn"};

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        if (!line.startsWith("tskv")) {
            return;
        }
        TskvSplitter splitter = new TskvSplitter(line);

        if (!ArrayUtils.contains(ALLOWED_LEVELS, splitter.getString("level"))) {
            return;
        }

        CommonContainer commonContainer = new CommonContainer();

        if (!commonContainer.fill(splitter)) {
            return;
        }
        ErrorsContainer errorsContainer = new ErrorsContainer();

        if (!errorsContainer.fill(splitter)) {
            return;
        }

        Long timestampSeconds = ParseUtils.parseLong(splitter.getString("unixtime"), 0L);

        context.write(
            new Date(timestampSeconds * 1000),
            ArrayUtils.addAll(commonContainer.serialize(), errorsContainer.serialize())
        );
    }
}
