package ru.yandex.market.logshatter.parser.front.errorBooster.qloudNode;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import ru.yandex.market.logshatter.parser.ParseUtils;
import ru.yandex.market.logshatter.parser.front.errorBooster.Environment;
import ru.yandex.market.logshatter.parser.front.errorBooster.Platform;
import ru.yandex.market.logshatter.parser.front.errorBooster.schema.CommonSchema;
import ru.yandex.market.logshatter.useragent.UserAgentDetector;

import java.util.Map;

public class CommonContainer extends CommonSchema {
    private UserAgentDetector detector;

    public CommonContainer(UserAgentDetector detector) {
        this.detector = detector;
    }

    public boolean fill(JsonObject jsonObject) {
        if (!jsonObject.has("@fields")) {
            return false;
        }
        JsonObject fields = jsonObject.getAsJsonObject("@fields");
        if (!fields.isJsonObject()) {
            return false;
        }

        if (!fields.has("project")) {
            return false;
        }
        project = fields.get("project").getAsString();

        if (fields.has("reqid")) {
            requestId = fields.get("reqid").getAsString();
        }

        if (fields.has("url")) {
            url = fields.get("url").getAsString();
        }

        if (fields.has("version")) {
            version = fields.get("version").getAsString();
        }

        if (fields.has("ua")) {
            String userAgent = fields.get("ua").getAsString();
            fillUaTraits(detector, userAgent);
        }

        if (fields.has("page")) {
            page = fields.get("page").getAsString();
        }

        if (fields.has("yandexuid")) {
            yandexuid = ParseUtils.parseUnsignedLong(fields.get("yandexuid").getAsString());
        }

        if (fields.has("region")) {
            region = ParseUtils.parseInt(fields.get("region").getAsString(), 0);
        }

        requestIdHash = ParseUtils.sipHash64(requestId);
        if (fields.has("env")) {
            environment = Environment.fromString(fields.get("env").getAsString());
        }
        if (fields.has("platform")) {
            platform = Platform.fromString(fields.get("platform").getAsString());
        }
        vhost = getVhost(url);
        urlId = ParseUtils.sipHash64(url);

        addKvItem("host", jsonObject.get("host").getAsString());
        addKvItem("qloud_instance", jsonObject.get("qloud_instance").getAsString());
        addKvItem("qloud_environment", jsonObject.get("qloud_environment").getAsString());
        addKvItem("qloud_component", jsonObject.get("qloud_component").getAsString());
        addKvItem("qloud_application", jsonObject.get("qloud_application").getAsString());

        if (fields.has("additional")) {
            try {
                JsonObject additional = fields.getAsJsonObject("additional");
                if (additional.isJsonObject()) {
                    for (Map.Entry<String, JsonElement> entry : additional.entrySet()) {
                        JsonElement value = entry.getValue();

                        addKvItem(entry.getKey(), value.isJsonPrimitive() ? value.getAsString() : value.toString());
                    }
                }
            } catch (JsonParseException ignored) {
            }
        }

        return true;
    }
}
