package ru.yandex.market.logshatter.parser.front.errorBooster.qloudNode;

import com.google.gson.JsonObject;
import ru.yandex.common.util.StringUtils;
import ru.yandex.market.logshatter.parser.ParseUtils;
import ru.yandex.market.logshatter.parser.front.errorBooster.LogLevel;
import ru.yandex.market.logshatter.parser.front.errorBooster.Parser;
import ru.yandex.market.logshatter.parser.front.errorBooster.Runtime;
import ru.yandex.market.logshatter.parser.front.errorBooster.schema.ErrorsSchema;

public class ErrorsContainer extends ErrorsSchema {
    public boolean fill(JsonObject jsonObject) {
        if (!jsonObject.has("@fields")) {
            return false;
        }
        JsonObject fields = jsonObject.getAsJsonObject("@fields");

        if (!fields.isJsonObject()) {
            return false;
        }
        if (fields.has("level")) {
            logLevel = LogLevel.fromString(fields.get("level").getAsString().toLowerCase());
        } else {
            logLevel = LogLevel.fromString(jsonObject.get("levelStr").getAsString().toLowerCase());
        }

        if (fields.has("msg")) {
            originalMessage = fields.get("msg").getAsString();
        }

        if (StringUtils.isEmpty(originalMessage)) {
            return false;
        }
        message = originalMessage;
        messageId = ParseUtils.sipHash64(message);

        if (fields.has("stack")) {
            originalStackTrace = fields.get("stack").getAsString();
        } else {
            originalStackTrace = jsonObject.get("stackTrace").getAsString();
        }
        stackTrace = originalStackTrace;
        stackTraceId = ParseUtils.sipHash64(stackTrace);

        if (fields.has("ua")) {
            userAgent = fields.get("ua").getAsString();
        }

        if (fields.has("source")) {
            source = fields.get("source").getAsString();
        }

        if (fields.has("sourceMethod")) {
            sourceMethod = fields.get("sourceMethod").getAsString();
        }

        if (fields.has("sourceType")) {
            sourceType = fields.get("sourceType").getAsString();
        }

        if (fields.has("block")) {
            block = fields.get("block").getAsString();
        }

        if (fields.has("method")) {
            method = fields.get("method").getAsString();
        }

        if (fields.has("ts")) {
            clientTimestamp = prepareClientTimestamp(fields.get("ts").getAsString());
        }

        fileId = ParseUtils.sipHash64(file);
        userAgentId = ParseUtils.sipHash64(userAgent);

        runtime = Runtime.NODEJS;
        parser = Parser.QLOUD_NODE;

        return true;
    }

    public Integer getClientTimestamp() {
        return clientTimestamp;
    }
}

