package ru.yandex.market.logshatter.parser.front.errorBooster.redirlog;

import com.google.common.base.Splitter;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import org.apache.commons.io.Charsets;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BlockstatDecoder {

    private final Map<String, String> blockstatData;

    // https://stat.yandex-team.ru/_api/dictionary?name=blockstat&format=json
    private final static String BLOSKSTAT_DATA_PATH = "front/blockstat.json";

    public BlockstatDecoder() {
        URL url = Resources.getResource(BLOSKSTAT_DATA_PATH);
        String json;
        try {
            json = Resources.toString(url, Charsets.UTF_8);
        } catch (IOException e) {
            throw new RuntimeException("Could not load blostat dictionary");
        }

        blockstatData = new Gson().fromJson(
            json,
            new TypeToken<HashMap<String, Object>>() {}.getType()
        );
    }

    public String decode(String str) {
        List<String> parts = Splitter.on(".").splitToList(str);
        return parts.stream()
            .map(part -> blockstatData.containsKey(part) ? blockstatData.get(part) : part)
            .collect(Collectors.joining("."));
    }
}
