package ru.yandex.market.logshatter.parser.front.errorBooster.redirlog.errors;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import org.apache.commons.lang.StringUtils;
import ru.yandex.market.logshatter.parser.ParseUtils;
import ru.yandex.market.logshatter.parser.front.errorBooster.Environment;
import ru.yandex.market.logshatter.parser.front.errorBooster.Platform;
import ru.yandex.market.logshatter.parser.front.errorBooster.schema.CommonSchema;
import ru.yandex.market.logshatter.useragent.UserAgentDetector;

import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Map;

import static ru.yandex.market.logshatter.parser.ParseUtils.parseTestBuckets;
import static ru.yandex.market.logshatter.parser.ParseUtils.sipHash64;

public class CommonContainer extends CommonSchema {
    private UserAgentDetector detector;

    public CommonContainer(UserAgentDetector detector) {
        this.detector = detector;
    }

    public boolean fill(Map<String, String> redirVars, Map<String, String> customVars) throws Exception {
        project = customVars.get("project");

        if (StringUtils.isEmpty(project)) {
            return false;
        }

        url = redirVars.get("HTTP_REFERER");

        urlId = sipHash64(url);
        vhost = getVhost(url);

        page = URLDecoder.decode(customVars.getOrDefault("page", ""), "UTF-8");
        platform = Platform.fromString(customVars.getOrDefault("platform", ""));
        version = URLDecoder.decode(customVars.getOrDefault("version", ""));
        service = customVars.getOrDefault("service", "");
        environment = Environment.fromString(customVars.getOrDefault("env", ""));
        testIds = this.getTestIds(redirVars.getOrDefault("slots", ""));

        String expFlagsString = customVars.get("experiments");
        if (expFlagsString != null) {
            expFlags = Arrays.asList(URLDecoder.decode(expFlagsString, "UTF-8").split(";"));
        }

        requestId = URLDecoder.decode(redirVars.getOrDefault("reqid", ""), "UTF-8");
        requestIdHash = sipHash64(requestId);
        yandexuid = ParseUtils.parseUnsignedLong(redirVars.get("yandexuid"));
        if (customVars.containsKey("yandexuid") && !customVars.get("yandexuid").isEmpty()) {
            yandexuid = ParseUtils.parseUnsignedLong(customVars.get("yandexuid"));
        }

        region = ParseUtils.parseInt(customVars.get("region"), 0);

        // TODO: наллы
        isAdblock = ParseUtils.parseInt(customVars.get("adb"), 0) > 0;

        String userAgent = URLDecoder.decode(customVars.getOrDefault("ua", ""), "UTF-8");
        fillUaTraits(detector, userAgent);

        if (redirVars.containsKey("is_robot")) {
            isRobot = true;
        }

        if (redirVars.containsKey("is_internal")) {
            isInternal = true;
        }

        String additional = URLDecoder.decode(customVars.getOrDefault("additional", ""), "UTF-8");

        try {
            JsonParser jsonParser = new JsonParser(); // TODO запомнить инстанс парсера в static поле?
            JsonElement jsonElement = jsonParser.parse(additional);

            if (jsonElement.isJsonObject()) {
                JsonObject additionalObject = jsonElement.getAsJsonObject();

                for (Map.Entry<String, JsonElement> entry : additionalObject.entrySet()) {
                    JsonElement value = entry.getValue();

                    addKvItem(entry.getKey(), value.isJsonPrimitive() ? value.getAsString() : value.toString());
                }
            }
        } catch (JsonParseException ignored) {}

        return true;
    }
}
