package ru.yandex.market.logshatter.parser.front.errorBooster.redirlog.errors;

import org.apache.commons.lang3.ArrayUtils;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParseUtils;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.front.errorBooster.redirlog.RedirlogParser;
import ru.yandex.market.logshatter.parser.front.errorBooster.schema.Schema;
import ru.yandex.market.logshatter.useragent.UserAgentDetector;

import java.util.Date;
import java.util.Map;

public class ErrorsParser implements LogParser {

    public ErrorsParser() { }

    @Override
    public TableDescription getTableDescription() {
        return Schema.TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        Map<String, String> redirParams = RedirlogParser.getParams(line);

        String path = redirParams.getOrDefault("path", "");

        if (PathError.fromString(path) == PathError.UNKNOWN) {
            return;
        }

        Map<String, String> vars = RedirlogParser.getVars(redirParams);

        UserAgentDetector userAgentDetector = context.getUserAgentDetector();

        CommonContainer commonContainer = new CommonContainer(userAgentDetector);

        if (!commonContainer.fill(redirParams, vars)) {
            return;
        }

        ErrorsContainer errorsContainer = new ErrorsContainer();

        if (!errorsContainer.fill(redirParams, vars)) {
            return;
        }

        Long timestampSeconds = ParseUtils.parseLong(redirParams.get("timestamp"), 0L);

        context.write(
            new Date(timestampSeconds * 1000),
            ArrayUtils.addAll(commonContainer.serialize(), errorsContainer.serialize())
        );
    }
}
