package ru.yandex.market.logshatter.parser.front.errorBooster.redirlog.errors;

public enum PathError {
    CLIENT(PathError.CLIENT_PATH),
    UNCAUGHT(PathError.UNCAUGHT_PATH),
    EXTERNAL(PathError.EXTERNAL_PATH),
    SCRIPT(PathError.SCRIPT_PATH),
    NODEJS(PathError.NODEJS_PATH),
    UNKNOWN("");

    private static final String CLIENT_PATH = "690.2354"; // tech.client_error
    private static final String UNCAUGHT_PATH = "690.2361"; // tech.uncaught_error
    private static final String EXTERNAL_PATH = "690.2854"; // tech.external_error
    private static final String SCRIPT_PATH = "690.2609"; // tech.script_error
    private static final String NODEJS_PATH = "690.3698"; // tech.nodejs_error

    private final String code;

    PathError(String code) {
        this.code = code;
    }

    public static PathError fromString(String path) {
        switch (path) {
            case CLIENT_PATH:
                return PathError.CLIENT;
            case UNCAUGHT_PATH:
                return PathError.UNCAUGHT;
            case EXTERNAL_PATH:
                return PathError.EXTERNAL;
            case SCRIPT_PATH:
                return PathError.SCRIPT;
            case NODEJS_PATH:
                return PathError.NODEJS;
            default:
                return PathError.UNKNOWN;
        }
    }
}