package ru.yandex.market.logshatter.parser.front.errorBooster.redirlog.rum;

import org.apache.commons.lang.StringUtils;
import ru.yandex.market.logshatter.parser.ParseUtils;
import ru.yandex.market.logshatter.parser.front.errorBooster.Environment;
import ru.yandex.market.logshatter.parser.front.errorBooster.Platform;
import ru.yandex.market.logshatter.parser.front.errorBooster.schema.CommonSchema;
import ru.yandex.market.logshatter.useragent.UserAgentDetector;

import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Map;

import static ru.yandex.market.logshatter.parser.ParseUtils.parseTestBuckets;
import static ru.yandex.market.logshatter.parser.ParseUtils.sipHash64;

public class CommonContainer extends CommonSchema {
    private UserAgentDetector detector;

    public CommonContainer(UserAgentDetector detector) {
        this.detector = detector;
    }

    public boolean fill(Map<String, String> redirVars, Map<String, String> customVars) throws Exception {
        project = customVars.get("project");

        if (StringUtils.isEmpty(project)) {
            return false;
        }

        // https://st.yandex-team.ru/ERRORBOOSTER-220
        //url = redirVars.get("HTTP_REFERER");

        //if (StringUtils.isEmpty(url)) {
        //    return false;
        //}
        //vhost = getVhost(url);

        urlId = sipHash64(url);
        vhost = getVhost(redirVars.get("HTTP_REFERER"));
        testIds = this.getTestIds(redirVars.getOrDefault("slots", ""));
        platform = Platform.fromString(customVars.getOrDefault("platform", ""));
        environment = Environment.fromString(customVars.getOrDefault("env", ""));
        version = customVars.getOrDefault("version", "");
        service = customVars.getOrDefault("service", "");
        page = URLDecoder.decode(customVars.getOrDefault("page", ""), "UTF-8");
        isAdblock = ParseUtils.parseInt(customVars.get("blocker"), 0) > 0;

        requestId = URLDecoder.decode(redirVars.getOrDefault("reqid", ""), "UTF-8");
        requestIdHash = sipHash64(requestId);
        yandexuid = ParseUtils.parseUnsignedLong(redirVars.get("yandexuid"));
        region = ParseUtils.parseInt(customVars.get("region"), 0);

        String expFlagsString = customVars.get("experiments");
        if (expFlagsString != null) {
            expFlags = Arrays.asList(URLDecoder.decode(expFlagsString, "UTF-8").split(";"));
        }

        String userAgent = URLDecoder.decode(customVars.getOrDefault("ua", ""), "UTF-8");
        fillUaTraits(detector, userAgent);

        if (redirVars.containsKey("is_robot")) {
            isRobot = true;
        }

        if (redirVars.containsKey("is_internal")) {
            isInternal = true;
        }

        return true;
    }
}