package ru.yandex.market.logshatter.parser.front.errorBooster.redirlog.rum;

import java.util.HashMap;
import java.util.Map;

public enum ConnectionType {
    CELLULAR_2G("cell_2g"),
    CELLULAR_3G("cell_3g"),
    CELLULAR_4G("cell_4g"),
    BLUETOOTH("bluethooth"), // Так в blockstat написано:)
    CELLULAR("cellular"),
    ETHERNET("ethernet"),
    NONE("none"),
    WIFI("wifi"),
    WIMAX("wimax"),
    OTHER("other"),
    UNKNOWN(null);

    private final String blockstatName;

    private static Map<String, ConnectionType> byNames = new HashMap<>();

    static {
        for (ConnectionType connectionType : values()) {
            if (connectionType.blockstatName != null) {
                byNames.put(connectionType.blockstatName, connectionType);
            }
        }
    }

    ConnectionType(String blockstatName) {
        this.blockstatName = blockstatName;
    }

    public static ConnectionType fromString(String blockstatName) {
        return byNames.getOrDefault(blockstatName, UNKNOWN);
    }
}
