package ru.yandex.market.logshatter.parser.front.errorBooster.redirlog.rum;

import org.apache.commons.lang.StringUtils;
import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;

import java.util.Map;

import static ru.yandex.market.logshatter.parser.front.errorBooster.redirlog.rum.RumParserUtils.parseUnsignedInt16;

public class DeltaContainer {

    public DeltaContainer() { }

    public static final String COLUMN_NAME = "name";
    protected String name = "";

    public static final String COLUMN_DELTA = "delta";
    protected Integer delta = 0;

    public static final String COLUMN_SUBPAGE_INDEX = "subpage_index";
    protected Integer subpageIndex = 0;

    public static final String COLUMN_SUBPAGE_NAME = "subpage_name";
    protected String subpageName = "";

    public static final Column[] fields = {
        new Column(COLUMN_NAME, ColumnType.String),
        new Column(COLUMN_DELTA, ColumnType.UInt16),
        new Column(COLUMN_SUBPAGE_INDEX, ColumnType.UInt16),
        new Column(COLUMN_SUBPAGE_NAME, ColumnType.String),
    };

    public boolean fill(Map<String, String> customVars) {
        name = customVars.get("id");

        if (StringUtils.isEmpty(name)) {
            return false;
        }

        subpageName = customVars.getOrDefault("subpage_name", "");
        subpageIndex = parseUnsignedInt16(customVars, "subpage_index");
        delta = parseUnsignedInt16(customVars, "delta");

        return true;
    }

    public Object[] serialize() {
        return new Object[]{
            name,
            delta,
            subpageIndex,
            subpageName
        };
    }
}