package ru.yandex.market.logshatter.parser.front.errorBooster.redirlog.rum;

import com.google.common.base.Splitter;
import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.ParseUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExternalResourcesContainer {

    public static final String COLUMN_RESOURCES_HOST = "resources_host";
    protected List<String> resourcesHost = new ArrayList<>();

    public static final String COLUMN_RESOURCES_COUNT = "resources_count";
    protected List<Integer> resourcesCount = new ArrayList<>();

    public static final String COLUMN_RESOURCES_SIZE = "resources_size";
    protected List<Integer> resourcesSize = new ArrayList<>();

    public ExternalResourcesContainer() { }

    public static final Column[] fields = {
        new Column(COLUMN_RESOURCES_HOST, ColumnType.ArrayString),
        new Column(COLUMN_RESOURCES_COUNT, ColumnType.ArrayInt16),
        new Column(COLUMN_RESOURCES_SIZE, ColumnType.ArrayInt32),
    };

    public boolean fill(Map<String, String> customVars) {
        String resources = customVars.getOrDefault("external_resources", "");

        for (String resource : Splitter.on(";").split(resources)) {
            List<String> resourceParts = Splitter.on("!").splitToList(resource);
            if (resourceParts.size() == 3) {
                Integer count = ParseUtils.parseInt(resourceParts.get(1), 0);
                if (count > 0) {
                    resourcesHost.add(resourceParts.get(0));
                    resourcesCount.add(count);
                    resourcesSize.add(ParseUtils.parseInt(resourceParts.get(2), 0));
                }
            }
        }

        return true;
    }

    public Object[] serialize() {
        return new Object[]{
            resourcesHost,
            resourcesCount,
            resourcesSize
        };
    }
}