package ru.yandex.market.logshatter.parser.front.errorBooster.redirlog.rum;

import org.apache.commons.lang3.ArrayUtils;
import ru.yandex.market.clickhouse.ddl.engine.MergeTree;
import ru.yandex.market.logshatter.parser.LogParser;
import ru.yandex.market.logshatter.parser.ParseUtils;
import ru.yandex.market.logshatter.parser.ParserContext;
import ru.yandex.market.logshatter.parser.TableDescription;
import ru.yandex.market.logshatter.parser.front.errorBooster.redirlog.RedirlogParser;
import ru.yandex.market.logshatter.useragent.UserAgentDetector;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class ExternalResourcesParser implements LogParser {

    public ExternalResourcesParser() { }

    public static final TableDescription TABLE_DESCRIPTION = TableDescription.create(
        new MergeTree(
            "toYYYYMMDD(" + TableDescription.DATE_COLUMN.getName() + ")",
            Arrays.asList(
                CommonContainer.COLUMN_PROJECT,
                CommonContainer.COLUMN_PLATFORM,
                TableDescription.TIMESTAMP_COLUMN.getName(),
                CommonContainer.COLUMN_YANDEXUID
            ),
            CommonContainer.COLUMN_YANDEXUID
        ),
        Arrays.asList(ArrayUtils.addAll(CommonContainer.fields, ExternalResourcesContainer.fields))
    );

    private static final Collection<String> BLOCKSTAT_VALUES = Arrays.asList(
        "external_resources"
    );

    @Override
    public TableDescription getTableDescription() {
        return TABLE_DESCRIPTION;
    }

    @Override
    public void parse(String line, ParserContext context) throws Exception {
        Map<String, String> redirParams = RedirlogParser.getParams(line);
        Map<String, String> vars = RedirlogParser.getVars(redirParams, BLOCKSTAT_VALUES);
        UserAgentDetector userAgentDetector = context.getUserAgentDetector();

        CommonContainer commonContainer = new CommonContainer(userAgentDetector);

        if (!commonContainer.fill(redirParams, vars)) {
            return;
        }

        ExternalResourcesContainer externalResourcesContainer = new ExternalResourcesContainer();

        if (!externalResourcesContainer.fill(vars)) {
            return;
        }

        Long timestampSeconds = ParseUtils.parseLong(redirParams.get("timestamp"), 0L);

        context.write(
            new Date(timestampSeconds * 1000),
            ArrayUtils.addAll(commonContainer.serialize(), externalResourcesContainer.serialize())
        );
    }
}
