package ru.yandex.market.logshatter.parser.front.errorBooster.redirlog.rum;

import com.google.common.base.Splitter;
import org.apache.commons.lang.StringUtils;
import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.logshatter.parser.ParseUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static ru.yandex.market.logshatter.parser.front.errorBooster.redirlog.rum.RumParserUtils.parseUnsignedInt16;
import static ru.yandex.market.logshatter.parser.front.errorBooster.redirlog.rum.RumParserUtils.toUnsignedInt16;

public class TimemarkContainer {

    public TimemarkContainer() { }

    public static final String COLUMN_NAME = "name";
    protected String name = "";

    public static final String COLUMN_TIME = "time";
    protected Integer time = 0;

    public static final String COLUMN_SUBPAGE_INDEX = "subpage_index";
    protected Integer subpageIndex = 0;

    public static final String COLUMN_SUBPAGE_NAME = "subpage_name";
    protected String subpageName = "";

    public static final String COLUMN_LONG_TASK_ALL = "long_task_all";
    protected Integer longTaskAll = 0;

    public static final String COLUMN_LONG_TASK_SELF = "long_task_self";
    protected Integer longTaskSelf = 0;

    public static final String COLUMN_LONG_TASK_UNKNOWN = "long_task_unknown";
    protected Integer longTaskUnknown = 0;

    public static final String COLUMN_LONG_TASK_MULTIPLE_CONTEXTS = "long_task_multiple_contexts";
    protected Integer longTaskMultipleContexts = 0;

    public static final String COLUMN_LONG_TASK_CROSS_ORIGIN_UNREACHABLE = "long_task_cross_origin_unreachable";
    protected Integer longTaskCrossOriginUnreachable = 0;

    public static final String COLUMN_LONG_TASK_CROSS_ORIGIN_DESCENDANT = "long_task_cross_origin_descendant";
    protected Integer longTaskCrossOriginDescendant = 0;

    public static final String COLUMN_LONG_TASK_CROSS_ORIGIN_ANCESTOR = "long_task_cross_origin_ancestor";
    protected Integer longTaskCrossOriginAncestor = 0;

    public static final String COLUMN_LONG_TASK_SAME_ORIGIN = "long_task_same_origin";
    protected Integer longTaskSameOrigin = 0;

    public static final String COLUMN_LONG_TASK_SAME_ORIGIN_DESCENDANT = "long_task_same_origin_descendant";
    protected Integer longTaskSameOriginDescendant = 0;

    public static final String COLUMN_LONG_TASK_SAME_ORIGIN_ANCESTOR = "long_task_same_origin_ancestor";
    protected Integer longTaskSameOriginAncestor = 0;

    public static final Column[] fields = {
        new Column(COLUMN_NAME, ColumnType.String),
        new Column(COLUMN_TIME, ColumnType.UInt16),
        new Column(COLUMN_SUBPAGE_INDEX, ColumnType.UInt16),
        new Column(COLUMN_SUBPAGE_NAME, ColumnType.String),
        new Column(COLUMN_LONG_TASK_ALL, ColumnType.UInt16),
        new Column(COLUMN_LONG_TASK_SELF, ColumnType.UInt16),
        new Column(COLUMN_LONG_TASK_UNKNOWN, ColumnType.UInt16),
        new Column(COLUMN_LONG_TASK_MULTIPLE_CONTEXTS, ColumnType.UInt16),
        new Column(COLUMN_LONG_TASK_CROSS_ORIGIN_UNREACHABLE, ColumnType.UInt16),
        new Column(COLUMN_LONG_TASK_CROSS_ORIGIN_DESCENDANT, ColumnType.UInt16),
        new Column(COLUMN_LONG_TASK_CROSS_ORIGIN_ANCESTOR, ColumnType.UInt16),
        new Column(COLUMN_LONG_TASK_SAME_ORIGIN, ColumnType.UInt16),
        new Column(COLUMN_LONG_TASK_SAME_ORIGIN_DESCENDANT, ColumnType.UInt16),
        new Column(COLUMN_LONG_TASK_SAME_ORIGIN_ANCESTOR, ColumnType.UInt16),
    };

    public boolean fill(Map<String, String> customVars) {
        name = customVars.get("id");

        if (StringUtils.isEmpty(name)) {
            return false;
        }

        subpageName = customVars.getOrDefault("subpage_name", "");
        subpageIndex = parseUnsignedInt16(customVars, "subpage_index");

        time = parseUnsignedInt16(customVars, "time");

        if (!StringUtils.isEmpty(subpageName)) {
            time = time - parseUnsignedInt16(customVars, "action.start_time");
        }

        time = toUnsignedInt16(time);

        String longTaskValue = customVars.getOrDefault("long-task.value", "");

        if (!StringUtils.isEmpty(longTaskValue)) {
            Map<String, Integer> tasks = new HashMap<>();
            for (String longTaskLine : Splitter.on(".").split(longTaskValue)) {
                List<String> longTaskLineParts = Splitter.on("-").splitToList(longTaskLine);
                if (longTaskLineParts.size() == 3) {
                    String task = longTaskLineParts.get(0);
                    Integer taskValue = ParseUtils.parseUnsignedInt(longTaskLineParts.get(2), 0) - ParseUtils.parseUnsignedInt(longTaskLineParts.get(1), 0);
                    Integer prevTaskValue = 0;

                    if (tasks.get(task) != null) {
                        prevTaskValue = tasks.get(task);
                    }

                    tasks.put(
                        task,
                        taskValue + prevTaskValue
                    );
                }

            }

            for (String task : tasks.keySet()) {
                Integer taskValue = toUnsignedInt16(tasks.get(task));
                longTaskAll += tasks.get(task);

                switch (task) {
                    case "s":
                        longTaskSelf = taskValue;
                        break;
                    case "soa":
                        longTaskSameOriginAncestor = taskValue;
                        break;
                    case "sod":
                        longTaskSameOriginDescendant = taskValue;
                        break;
                    case "so":
                        longTaskSameOrigin = taskValue;
                        break;
                    case "coa":
                        longTaskCrossOriginAncestor = taskValue;
                        break;
                    case "cod":
                        longTaskCrossOriginDescendant = taskValue;
                        break;
                    case "cou":
                        longTaskCrossOriginUnreachable = taskValue;
                        break;
                    case "mc":
                        longTaskMultipleContexts = taskValue;
                        break;
                    case "u":
                        longTaskUnknown = taskValue;
                        break;
                }
            }

            longTaskAll = toUnsignedInt16(longTaskAll);
        }
        return true;
    }

    public Object[] serialize() {
        return new Object[]{
            name,
            time,
            subpageIndex,
            subpageName,
            longTaskAll,
            longTaskSelf,
            longTaskUnknown,
            longTaskMultipleContexts,
            longTaskCrossOriginUnreachable,
            longTaskCrossOriginDescendant,
            longTaskCrossOriginAncestor,
            longTaskSameOrigin,
            longTaskSameOriginDescendant,
            longTaskSameOriginAncestor
        };
    }
}