package ru.yandex.market.logshatter.parser.front.errorBooster.redirlog.rum;

import ru.yandex.market.clickhouse.ddl.Column;
import ru.yandex.market.clickhouse.ddl.ColumnType;
import ru.yandex.market.clickhouse.ddl.enums.EnumColumnType;
import ru.yandex.market.logshatter.parser.ParseUtils;

import java.util.Map;

import static ru.yandex.market.logshatter.parser.front.errorBooster.redirlog.rum.RumParserUtils.parseUnsignedInt16;

public class TimingContainer {

    public static final String COLUMN_NAVIGATION_START = "navigation_start";
    protected Integer navigationStart = 0;

    public static final String COLUMN_RESPONSE_START = "response_start";
    protected Integer responseStart = 0;

    public static final String COLUMN_RESPONSE_END = "response_end";
    protected Integer responseEnd = 0;

    public static final String COLUMN_DOMAIN_LOOKUP_START = "domain_lookup_start";
    protected Integer domainLookupStart = 0;

    public static final String COLUMN_DOMAIN_LOOKUP_END = "domain_lookup_end";
    protected Integer domainLookupEnd = 0;

    public static final String COLUMN_REQUEST_START = "request_start";
    protected Integer requestStart = 0;

    public static final String COLUMN_FETCH_START = "fetch_start";
    protected Integer fetchStart = 0;

    public static final String COLUMN_DOM_LOADING_TOTAL = "dom_loading_total";
    protected Integer domLoadingTotal = 0;

    public static final String COLUMN_DOM_INTERACTIVE_TOTAL = "dom_interactive_total";
    protected Integer domInteractiveTotal = 0;

    public static final String COLUMN_DOM_CONTENT_LOADED = "dom_content_loaded";
    protected Integer domContentLoaded = 0;

    public static final String COLUMN_DOM_CONTENT_LOADED_FINISHED = "dom_content_loaded_finished";
    protected Integer domContentLoadedFinished = 0;

    public static final String COLUMN_CONNECT_START = "connect_start";
    protected Integer connectStart = 0;

    public static final String COLUMN_CONNECT_END = "connect_end";
    protected Integer connectEnd = 0;

    public static final String COLUMN_HISTORY_LENGTH = "history_length";
    protected Integer historyLength = 0;

    public static final String COLUMN_DOM_LOADED = "dom_loaded";
    protected Integer domLoaded = 0;

    public static final String COLUMN_DOM_INIT = "dom_init";
    protected Integer domInit = 0;

    public static final String COLUMN_DOM_INTERACTIVE = "dom_interactive";
    protected Integer domInteractive = 0;

    public static final String COLUMN_DOM_LOADING = "dom_loading";
    protected Integer domLoading = 0;

    public static final String COLUMN_HTML_TOTAL = "html_total";
    protected Integer htmlTotal = 0;

    public static final String COLUMN_HTML = "html";
    protected Integer html = 0;

    public static final String COLUMN_TTFB = "ttfb";
    protected Integer ttfb = 0;

    public static final String COLUMN_TCP = "tcp";
    protected Integer tcp = 0;

    public static final String COLUMN_DNS = "dns";
    protected Integer dns = 0;

    public static final String COLUMN_WAIT = "wait";
    protected Integer wait = 0;

    public static final String COLUMN_VISIBILITY = "visibility";
    protected Visibility visibility = Visibility.UNKNOWN;

    public static final String COLUMN_CONNECTION_TYPE = "connection_type";
    protected ConnectionType connectionType = ConnectionType.UNKNOWN;

    public static final String COLUMN_DEVICE_MEMORY = "device_memory";
    protected Integer deviceMemory = 0;

    public static final String COLUMN_NAVIGATION_TYPE = "navigation_type";
    protected NavigationType navigationType = NavigationType.UNKNOWN;

    public static final String COLUMN_EFFECTIVE_TYPE = "effective_type";
    protected String effectiveType = "";

    public static final String COLUMN_HARDWARE_CONCURRENCY = "hardware_concurrency";
    protected Integer hardwareConcurrency = 0;

    public static final String COLUMN_SSL = "ssl";
    protected Integer ssl = 0;

    public static final String COLUMN_TTFP = "ttfp";
    protected Integer ttfp = 0;

    public static final String COLUMN_TTFP_TOTAL = "ttfp_total";
    protected Integer ttfpTotal = 0;

    public static final String COLUMN_FIRST_PAINT_TIME = "first_paint_time";
    protected Integer firstPaintTime = 0;

    public static final String COLUMN_SECURE_CONNECTION_START = "secure_connection_start";
    protected Integer secureConnectionStart = 0;

    public static final String COLUMN_UNLOAD_START = "unload_start";
    protected Integer unloadStart = 0;

    public static final String COLUMN_UNLOAD_END = "unload_end";
    protected Integer unloadEnd = 0;

    public static final String COLUMN_REDIRECT_COUNT = "redirect_count";
    protected Integer redirectCount = 0;

    public static final String COLUMN_REDIRECT_START = "redirect_start";
    protected Integer redirectStart = 0;

    public static final String COLUMN_REDIRECT_END = "redirect_end";
    protected Integer redirectEnd = 0;

    public TimingContainer() { }

    public static final Column[] fields = {
        new Column(COLUMN_NAVIGATION_START, ColumnType.UInt32),
        new Column(COLUMN_RESPONSE_START, ColumnType.UInt16),
        new Column(COLUMN_RESPONSE_END, ColumnType.UInt16),
        new Column(COLUMN_DOMAIN_LOOKUP_START, ColumnType.UInt16),
        new Column(COLUMN_DOMAIN_LOOKUP_END, ColumnType.UInt16),
        new Column(COLUMN_REQUEST_START, ColumnType.UInt16),
        new Column(COLUMN_FETCH_START, ColumnType.UInt16),
        new Column(COLUMN_DOM_LOADING_TOTAL, ColumnType.UInt16),
        new Column(COLUMN_DOM_INTERACTIVE_TOTAL, ColumnType.UInt16),
        new Column(COLUMN_DOM_CONTENT_LOADED, ColumnType.UInt16),
        new Column(COLUMN_DOM_CONTENT_LOADED_FINISHED, ColumnType.UInt16),
        new Column(COLUMN_CONNECT_START, ColumnType.UInt16),
        new Column(COLUMN_CONNECT_END, ColumnType.UInt16),
        new Column(COLUMN_HISTORY_LENGTH, ColumnType.UInt16),
        new Column(COLUMN_DOM_LOADED, ColumnType.UInt16),
        new Column(COLUMN_DOM_INIT, ColumnType.UInt16),
        new Column(COLUMN_DOM_INTERACTIVE, ColumnType.UInt16),
        new Column(COLUMN_DOM_LOADING, ColumnType.UInt16),
        new Column(COLUMN_HTML_TOTAL, ColumnType.UInt16),
        new Column(COLUMN_HTML, ColumnType.UInt16),
        new Column(COLUMN_TTFB, ColumnType.UInt16),
        new Column(COLUMN_TCP, ColumnType.UInt16),
        new Column(COLUMN_DNS, ColumnType.UInt16),
        new Column(COLUMN_WAIT, ColumnType.UInt16),
        new Column(COLUMN_VISIBILITY, EnumColumnType.enum8(Visibility.class)),
        new Column(COLUMN_CONNECTION_TYPE, EnumColumnType.enum8(ConnectionType.class)),
        new Column(COLUMN_DEVICE_MEMORY, ColumnType.UInt8),
        new Column(COLUMN_NAVIGATION_TYPE, EnumColumnType.enum8(NavigationType.class)),
        new Column(COLUMN_EFFECTIVE_TYPE, ColumnType.String),
        new Column(COLUMN_HARDWARE_CONCURRENCY, ColumnType.UInt8),
        new Column(COLUMN_SSL, ColumnType.UInt16),
        new Column(COLUMN_TTFP, ColumnType.UInt16),
        new Column(COLUMN_TTFP_TOTAL, ColumnType.UInt16),
        new Column(COLUMN_FIRST_PAINT_TIME, ColumnType.UInt16),
        new Column(COLUMN_SECURE_CONNECTION_START, ColumnType.UInt16),
        new Column(COLUMN_UNLOAD_START, ColumnType.UInt16),
        new Column(COLUMN_UNLOAD_END, ColumnType.UInt16),
        new Column(COLUMN_REDIRECT_COUNT, ColumnType.UInt16),
        new Column(COLUMN_REDIRECT_START, ColumnType.UInt16),
        new Column(COLUMN_REDIRECT_END, ColumnType.UInt16),

    };

    public boolean fill(Map<String, String> customVars) {
        responseStart = parseUnsignedInt16(customVars, "response_start");
        responseEnd = parseUnsignedInt16(customVars, "response_end");
        domainLookupStart = parseUnsignedInt16(customVars, "domain_lookup_start");
        domainLookupEnd = parseUnsignedInt16(customVars, "domain_lookup_end");
        requestStart = parseUnsignedInt16(customVars, "request_start");
        fetchStart = parseUnsignedInt16(customVars, "fetch_start");
        domLoadingTotal = parseUnsignedInt16(customVars, "dom_loading_total");
        domInteractiveTotal = parseUnsignedInt16(customVars, "dom_interactive_total");
        domContentLoaded = parseUnsignedInt16(customVars, "dom_content_loaded");
        domContentLoadedFinished = parseUnsignedInt16(customVars, "dom_content_loaded_finished");
        connectStart = parseUnsignedInt16(customVars, "connect_start");
        connectEnd = parseUnsignedInt16(customVars, "connect_end");
        historyLength = parseUnsignedInt16(customVars, "history-length");
        domLoaded = parseUnsignedInt16(customVars, "dom.loaded");
        domInit = parseUnsignedInt16(customVars, "dom.init");
        domInteractive = parseUnsignedInt16(customVars, "dom.interactive");
        domLoading = parseUnsignedInt16(customVars, "dom.loading");
        htmlTotal = parseUnsignedInt16(customVars, "html.total");
        html = parseUnsignedInt16(customVars, "html");
        ttfb = parseUnsignedInt16(customVars, "ttfb");
        tcp = parseUnsignedInt16(customVars, "tcp");
        dns = parseUnsignedInt16(customVars, "dns");
        wait = parseUnsignedInt16(customVars, "wait");
        deviceMemory = parseUnsignedInt16(customVars, "device_memory");
        hardwareConcurrency = parseUnsignedInt16(customVars, "hardware_concurrency");
        ssl = parseUnsignedInt16(customVars, "ssl");
        ttfp = parseUnsignedInt16(customVars, "ttfp");
        ttfpTotal = parseUnsignedInt16(customVars, "ttfp.total");
        firstPaintTime = parseUnsignedInt16(customVars, "first_paint_time");
        secureConnectionStart = parseUnsignedInt16(customVars, "secure_connection_start");
        unloadStart = parseUnsignedInt16(customVars, "unload_start");
        unloadEnd = parseUnsignedInt16(customVars, "unload_end");

        navigationStart = prepareClientTimestamp(customVars.getOrDefault("navigation_start", ""));
        visibility = Visibility.fromString(customVars.getOrDefault("visibility", ""));
        connectionType = ConnectionType.fromString(customVars.getOrDefault("connection_type", ""));
        navigationType = NavigationType.fromString(customVars.getOrDefault("nav.type", ""));
        effectiveType = customVars.getOrDefault("effective_type", "");
        redirectCount = parseUnsignedInt16(customVars, "redirect.count");
        redirectStart = parseUnsignedInt16(customVars, "redirect_start");
        redirectEnd = parseUnsignedInt16(customVars, "redirect_end");
        return true;
    }

    public Object[] serialize() {
        return new Object[]{
            navigationStart,
            responseStart,
            responseEnd,
            domainLookupStart,
            domainLookupEnd,
            requestStart,
            fetchStart,
            domLoadingTotal,
            domInteractiveTotal,
            domContentLoaded,
            domContentLoadedFinished,
            connectStart,
            connectEnd,
            historyLength,
            domLoaded,
            domInit,
            domInteractive,
            domLoading,
            htmlTotal,
            html,
            ttfb,
            tcp,
            dns,
            wait,
            visibility,
            connectionType,
            deviceMemory,
            navigationType,
            effectiveType,
            hardwareConcurrency,
            ssl,
            ttfp,
            ttfpTotal,
            firstPaintTime,
            secureConnectionStart,
            unloadStart,
            unloadEnd,
            redirectCount,
            redirectStart,
            redirectEnd
        };
    }

    public int prepareClientTimestamp(String timestamp) {
        long safeClientTimestamp = ParseUtils.parseLong(timestamp, 0L) / 1000;

        if (safeClientTimestamp <= Integer.MAX_VALUE) {
            return (int) safeClientTimestamp;
        }
        return 0;
    }
}