package ru.yandex.market.logshatter.parser.front.errorBooster.reportRenderer;

import com.google.gson.JsonObject;
import ru.yandex.market.logshatter.parser.ParseUtils;
import ru.yandex.market.logshatter.parser.front.errorBooster.Environment;
import ru.yandex.market.logshatter.parser.front.errorBooster.Platform;
import ru.yandex.market.logshatter.parser.front.errorBooster.schema.CommonSchema;
import ru.yandex.market.logshatter.useragent.UserAgentDetector;

import java.util.Arrays;
import java.util.Map;

import static ru.yandex.market.logshatter.parser.ParseUtils.parseTestBuckets;
import static ru.yandex.market.logshatter.parser.ParseUtils.sipHash64;

public class CommonContainer extends CommonSchema {
    private static String PROJECT_WITHOUT_TEMPLATE_PATH = "report-renderer-empty-template";
    private static String PROJECT_WITH_UNKNOWN_NAME = "report-renderer-unknown-project";
    private UserAgentDetector detector;

    public CommonContainer(UserAgentDetector detector) {
        this.detector = detector;
    }

    public boolean fill(JsonObject jsonObject, Map<String, String> meta, JsonObject projects, JsonObject platforms) {
        if (meta.containsKey("project")) {
            project = meta.get("project");
        } else {
            if (jsonObject.has("templatePath")) {
                String templatePath = jsonObject.get("templatePath").getAsString();
                if (projects.has(templatePath)) {
                    project = projects.get(templatePath).getAsString();
                } else {
                    project = PROJECT_WITH_UNKNOWN_NAME;
                    addKvItem("templatePath", templatePath);
                }

                if (platforms.has(templatePath)) {
                    platform = Platform.fromString(platforms.get(templatePath).getAsString());
                }
            } else {
                project = PROJECT_WITHOUT_TEMPLATE_PATH;
            }
        }

        if (jsonObject.has("requestId")) {
            requestId = jsonObject.get("requestId").getAsString();
        }

        requestIdHash = sipHash64(requestId);

        if (meta.containsKey("env")) {
            environment = Environment.fromString(meta.get("env"));
        } else {
            environment = prepareEnvironment(jsonObject.get("ctype").getAsString());
        }

        if (meta.containsKey("ua")) {
            String userAgent = meta.get("ua");
            fillUaTraits(detector, userAgent);
        }

        if (meta.containsKey("version")) {
            version = meta.get("version");
        }

        if (meta.containsKey("page")) {
            page = meta.get("page");
        }

        if (meta.containsKey("service")) {
            service = meta.get("service");
        }
        
        if (meta.containsKey("platform")) {
            platform = Platform.fromString(meta.get("platform"));
        }

        if (meta.containsKey("slots")) {
            testIds = this.getTestIds(meta.get("slots"));
        }

        if (meta.containsKey("region")) {
            region = ParseUtils.parseInt(meta.get("region"), 0);
        }

        if (meta.containsKey("yandexuid")) {
            yandexuid = ParseUtils.parseUnsignedLong(meta.get("yandexuid"));
        }

        if (meta.containsKey("url")) {
            url = meta.get("url");
        }

        if (meta.containsKey("isSuspectedRobot") && ParseUtils.parseInt(meta.get("isSuspectedRobot"), 0) == 1) {
            isRobot = true;
        }

        if (meta.containsKey("isInternalRequest") && ParseUtils.parseInt(meta.get("isInternalRequest"), 0) == 1) {
            isInternal = true;
        }

        urlId = sipHash64(url);
        vhost = getVhost(url);

        addKvItem("geo", jsonObject.get("geo").getAsString());
        addKvItem("metaprj", jsonObject.get("metaprj").getAsString());
        addKvItem("prj", jsonObject.get("prj").getAsString());

        return true;
    }

    public Environment prepareEnvironment(String ctype) {
        switch (ctype) {
            case "prod":
            case "prestable":
                return Environment.PRODUCTION;
            case "hamster":
                return Environment.DEVELOPMENT;
            case "priemka":
            case "priemka-templates":
            case "testing":
                return Environment.TESTING;
            default:
                return Environment.UNKNOWN;
        }
    }
}
